/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.handler;

import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import rabbit.data.access.IAccessor;
import rabbit.data.store.IStorer;
import rabbit.data.xml.XmlModule;

public class DataHandler {
    private static final Injector injector = Guice.createInjector((Module[])new Module[]{new XmlModule()});

    public static <T> IStorer<T> getStorer(Class<T> clazz) {
        try {
            Key k = Key.get((Type)Types.newParameterizedType(IStorer.class, (Type[])new Type[]{clazz}));
            return (IStorer)injector.getInstance(k);
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    public static <T> IAccessor<T> getAccessor(Class<T> clazz) {
        try {
            Key k = Key.get((Type)Types.newParameterizedType(IAccessor.class, (Type[])new Type[]{clazz}));
            return (IAccessor)injector.getInstance(k);
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }

    private DataHandler() {
    }
}

