/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.merge;

import com.google.common.base.Preconditions;
import rabbit.data.internal.xml.merge.IMerger;

public abstract class AbstractMerger<T>
implements IMerger<T> {
    protected AbstractMerger() {
    }

    @Override
    public final boolean isMergeable(T t1, T t2) {
        Preconditions.checkNotNull(t1);
        Preconditions.checkNotNull(t2);
        return this.doIsMergeable(t1, t2);
    }

    @Override
    public final T merge(T t1, T t2) {
        if (!this.isMergeable(t1, t2)) {
            throw new IllegalArgumentException("Objects are not mergeable");
        }
        return this.doMerge(t1, t2);
    }

    protected abstract boolean doIsMergeable(T var1, T var2);

    protected abstract T doMerge(T var1, T var2);
}

