/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import java.util.Observable;
import java.util.Observer;
import javax.annotation.Nullable;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import rabbit.tracking.internal.IdleDetector;
import rabbit.tracking.internal.TrackingPlugin;
import rabbit.tracking.internal.trackers.AbstractTracker;
import rabbit.tracking.internal.util.Recorder;
import rabbit.tracking.internal.util.WorkbenchUtil;

public abstract class AbstractPartTracker<E>
extends AbstractTracker<E> {
    private final Recorder<IWorkbenchPart> recorder = new Recorder();
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            AbstractPartTracker.this.recorder.start(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part.equals(AbstractPartTracker.this.recorder.getUserData())) {
                AbstractPartTracker.this.recorder.stop();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            AbstractPartTracker.this.recorder.stop();
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == part.getSite().getPage().getActivePart()) {
                AbstractPartTracker.this.recorder.start(part);
            }
        }
    };
    private final IWindowListener winListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            AbstractPartTracker.this.checkStart(window.getPartService().getActivePart());
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.getPartService().removePartListener(AbstractPartTracker.this.partListener);
            AbstractPartTracker.this.recorder.stop();
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            AbstractPartTracker.this.recorder.stop();
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.getPartService().addPartListener(AbstractPartTracker.this.partListener);
            if (WorkbenchUtil.isActiveShell(window)) {
                AbstractPartTracker.this.checkStart(window.getPartService().getActivePart());
            }
        }
    };
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            IWorkbenchPart part;
            long end;
            long start;
            Object event;
            if (!AbstractPartTracker.this.isEnabled()) {
                return;
            }
            if (o == TrackingPlugin.getDefault().getIdleDetector()) {
                if (((IdleDetector)o).isUserActive()) {
                    AbstractPartTracker.this.checkStart(WorkbenchUtil.getActivePart());
                } else {
                    AbstractPartTracker.this.recorder.stop();
                }
            } else if (o == AbstractPartTracker.this.recorder && (event = AbstractPartTracker.this.tryCreateEvent(start = AbstractPartTracker.this.recorder.getLastRecord().getStartTimeMillis(), end = AbstractPartTracker.this.recorder.getLastRecord().getEndTimeMillis(), part = (IWorkbenchPart)AbstractPartTracker.this.recorder.getLastRecord().getUserData())) != null) {
                AbstractPartTracker.this.addData(event);
            }
        }
    };

    public AbstractPartTracker() {
        this.recorder.addObserver(this.observer);
    }

    @Override
    protected void doDisable() {
        TrackingPlugin.getDefault().getIdleDetector().deleteObserver(this.observer);
        PlatformUI.getWorkbench().removeWindowListener(this.winListener);
        for (IPartService s : WorkbenchUtil.getPartServices()) {
            s.removePartListener(this.partListener);
        }
        this.recorder.stop();
    }

    @Override
    protected void doEnable() {
        TrackingPlugin.getDefault().getIdleDetector().addObserver(this.observer);
        PlatformUI.getWorkbench().addWindowListener(this.winListener);
        for (IPartService s : WorkbenchUtil.getPartServices()) {
            s.addPartListener(this.partListener);
        }
        IWorkbenchWindow win = WorkbenchUtil.getActiveWindow();
        if (WorkbenchUtil.isActiveShell(win)) {
            this.checkStart(win.getPartService().getActivePart());
        }
    }

    protected abstract E tryCreateEvent(long var1, long var3, IWorkbenchPart var5);

    private void checkStart(@Nullable IWorkbenchPart part) {
        if (part != null) {
            this.recorder.start(part);
        }
    }
}

