/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.joda.time.Interval;
import rabbit.data.handler.DataHandler;
import rabbit.data.store.IStorer;
import rabbit.data.store.model.FileEvent;
import rabbit.tracking.internal.trackers.AbstractPartTracker;

public class FileTracker
extends AbstractPartTracker<FileEvent> {
    @Override
    protected IStorer<FileEvent> createDataStorer() {
        return DataHandler.getStorer(FileEvent.class);
    }

    @Override
    protected FileEvent tryCreateEvent(long start, long end, IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                return new FileEvent(new Interval(start, end), file.getFullPath());
            }
            if (input instanceof IURIEditorInput) {
                URI uri = ((IURIEditorInput)input).getURI();
                Path path = new Path(uri.getPath());
                return new FileEvent(new Interval(start, end), (IPath)path);
            }
        }
        return null;
    }
}

