/*
 * Decompiled with CFR 0.152.
 */
package com.openedge.pdt.analytics.readers;

import com.openedge.pdt.analytics.readers.DataReaderModel;
import com.openedge.pdt.analytics.readers.PartEventReader;
import com.openedge.pdt.core.OECommonServicesPlugin;
import com.openedge.pdt.core.analytics.AnalyticsHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rabbit.tracking.internal.TrackingPlugin;

public class XmlReader {
    Properties prop = new Properties();

    public void processXML(DataReaderModel model) {
        IPath path = TrackingPlugin.getDefault().getStateLocation().append("analytics");
        try {
            File fXmlFile;
            block19: {
                NodeList nList;
                block15: {
                    URL url = new URL("platform:/plugin/com.openedge.pdt.analytics/analytics.properties");
                    InputStream input = url.openConnection().getInputStream();
                    this.prop.load(input);
                    fXmlFile = new File(path.toOSString().concat(model.getFileName()));
                    if (!fXmlFile.exists()) {
                        return;
                    }
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(fXmlFile);
                    nList = doc.getElementsByTagName(model.getTagName());
                    if (!model.getEventType().equals("Sessions") && !model.getEventType().equals("Launches")) break block15;
                    int i = 0;
                    while (i < nList.getLength()) {
                        block16: {
                            long duration;
                            block18: {
                                Element eElement;
                                block17: {
                                    Node nNode = nList.item(i);
                                    if (nNode.getNodeType() != 1) break block16;
                                    eElement = (Element)nNode;
                                    if (!model.getEventType().equals("Sessions")) break block17;
                                    duration = Math.round(Float.parseFloat(eElement.getAttribute(model.getValueID())) / (float)model.getFactor());
                                    break block18;
                                }
                                if (!model.getEventType().equals("Launches") || !this.isElementRequired(eElement.getAttribute(model.getAttrID()))) break block16;
                                duration = Math.round(Float.parseFloat(eElement.getAttribute(model.getValueID())) / Float.parseFloat(eElement.getAttribute("count")));
                            }
                            AnalyticsHandler.getInstance().trackFeatureValue(model.getFeatureGroup(), duration);
                        }
                        ++i;
                    }
                    break block19;
                }
                if (model.getEventType().equals("Parts") || model.getEventType().endsWith("Perspective")) {
                    int i = 0;
                    while (i < nList.getLength()) {
                        Element eElement;
                        String partIdAttr;
                        Node nNode = nList.item(i);
                        if (nNode.getNodeType() == 1 && this.isElementRequired(partIdAttr = (eElement = (Element)nNode).getAttribute(model.getAttrID()))) {
                            int duration = Math.round(Float.parseFloat(eElement.getAttribute(model.getValueID())) / (float)model.getFactor());
                            String featureName = this.getPropertyValue(partIdAttr);
                            if (featureName.endsWith("View")) {
                                featureName = featureName.substring(0, featureName.length() - 5);
                                do {
                                    AnalyticsHandler.getInstance().trackFeature(String.valueOf(PartEventReader.getInstance().getViewGroup()) + "." + featureName);
                                } while (--duration > 0);
                            } else {
                                do {
                                    AnalyticsHandler.getInstance().trackFeature(String.valueOf(model.getFeatureGroup()) + "." + featureName);
                                } while (--duration > 0);
                            }
                        }
                        ++i;
                    }
                }
            }
            fXmlFile.delete();
        }
        catch (Exception e) {
            OECommonServicesPlugin.log((Throwable)e, (String)"com.openedge.pdt.analytics", (String)"Error while pushing analytics data");
        }
    }

    public Set<Object> getAllKeys() {
        Set<Object> keys = this.prop.keySet();
        return keys;
    }

    private String getPropertyValue(String key) {
        return this.prop.getProperty(key);
    }

    public boolean isElementRequired(String partId) {
        Set<Object> requiredIds = this.getAllKeys();
        for (Object key : requiredIds) {
            if (!key.equals(partId)) continue;
            return true;
        }
        return false;
    }
}

