/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml;

import com.openedge.pdt.core.OECommonServicesPlugin;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class DatatypeUtil {
    public static DatatypeFactory datatypeFactory;

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                OECommonServicesPlugin.log((Throwable)ex, (String)"com.openedge.pdt.analytics");
            }
        }
    }

    public static boolean isSameDate(DateTime date1, XMLGregorianCalendar date2) {
        return date2.getYear() == date1.getYear() && date2.getMonth() == date1.getMonthOfYear() && date2.getDay() == date1.getDayOfMonth();
    }

    public static boolean isSameMonthInYear(DateTime cal1, DateTime cal2) {
        return cal1.getYear() == cal2.getYear() && cal1.getMonthOfYear() == cal2.getMonthOfYear();
    }

    public static boolean isSameMonthInYear(DateTime cal1, LocalDate cal2) {
        return cal1.getYear() == cal2.getYear() && cal1.getMonthOfYear() == cal2.getMonthOfYear();
    }

    public static LocalDate toLocalDate(XMLGregorianCalendar cal) {
        return new LocalDate(cal.getYear(), cal.getMonth(), cal.getDay());
    }

    public static XMLGregorianCalendar toXmlDate(DateTime cal) {
        return datatypeFactory.newXMLGregorianCalendarDate(cal.getYear(), cal.getMonthOfYear(), cal.getDayOfMonth(), Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar toXmlDate(LocalDate cal) {
        return datatypeFactory.newXMLGregorianCalendarDate(cal.getYear(), cal.getMonthOfYear(), cal.getDayOfMonth(), Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar toXmlDateTime(GregorianCalendar cal) {
        return datatypeFactory.newXMLGregorianCalendar(cal);
    }
}

