/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.util;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class WorkbenchUtil {
    public static IWorkbenchWindow getActiveWindow() {
        if (Display.getCurrent() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        final IWorkbenchWindow[] win = new IWorkbenchWindow[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                win[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return win[0];
    }

    public static boolean isActiveShell(IWorkbenchWindow win) {
        final Shell shell = win.getShell();
        final boolean[] result = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = shell.getDisplay().getActiveShell() == shell && !shell.getMinimized();
            }
        });
        return result[0];
    }

    public static IWorkbenchPart getActivePart() {
        return WorkbenchUtil.getActiveWindow().getPartService().getActivePart();
    }

    public static Set<IPartService> getPartServices() {
        IWorkbenchWindow[] ws;
        LinkedHashSet<IPartService> result = new LinkedHashSet<IPartService>();
        IWorkbenchWindow[] iWorkbenchWindowArray = ws = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = ws.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            result.add(w.getPartService());
            ++n2;
        }
        return result;
    }

    public static IPerspectiveDescriptor getPerspective(@Nullable IWorkbenchWindow win) {
        if (win == null) {
            return null;
        }
        IWorkbenchPage page = win.getActivePage();
        if (page != null) {
            return page.getPerspective();
        }
        return null;
    }
}

