/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.access.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IFile;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IKey;
import rabbit.data.access.model.ILaunchData;
import rabbit.data.access.model.LaunchConfigurationDescriptor;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.KeyMapBuilder;

public class LaunchData
implements ILaunchData {
    private final Map<IKey<? extends Object>, Object> data;

    public LaunchData(LocalDate date, WorkspaceStorage workspace, LaunchConfigurationDescriptor config, int count, Duration duration, Set<IFile> files) {
        Preconditions.checkArgument((count >= 1 ? 1 : 0) != 0, (Object)"count < 1");
        this.data = new KeyMapBuilder().put(COUNT, count).put(DATE, (LocalDate)Preconditions.checkNotNull((Object)date, (Object)"date")).put(WORKSPACE, (WorkspaceStorage)Preconditions.checkNotNull((Object)workspace, (Object)"workspace")).put(LAUNCH_CONFIG, (LaunchConfigurationDescriptor)Preconditions.checkNotNull((Object)config, (Object)"config")).put(DURATION, (Duration)Preconditions.checkNotNull((Object)duration, (Object)"duration")).put(FILES, ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(files, (Object)"files")))).build();
    }

    @Override
    public <T> T get(@Nullable IKey<T> key) {
        return (T)this.data.get(key);
    }
}

