/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.merge;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import rabbit.data.internal.xml.merge.AbstractMerger;
import rabbit.data.internal.xml.schema.events.LaunchEventType;

public class LaunchEventTypeMerger
extends AbstractMerger<LaunchEventType> {
    @Override
    protected boolean doIsMergeable(LaunchEventType t1, LaunchEventType t2) {
        return t1.getName() != null && t1.getName().equals(t2.getName()) && t1.getLaunchModeId() != null && t1.getLaunchModeId().equals(t2.getLaunchModeId()) && t1.getLaunchTypeId() != null && t1.getLaunchTypeId().equals(t2.getLaunchTypeId());
    }

    @Override
    protected LaunchEventType doMerge(LaunchEventType t1, LaunchEventType t2) {
        LaunchEventType result = new LaunchEventType();
        result.setLaunchModeId(t1.getLaunchModeId());
        result.setLaunchTypeId(t1.getLaunchTypeId());
        result.setName(t1.getName());
        result.setCount(t1.getCount() + t2.getCount());
        result.setTotalDuration(t1.getTotalDuration() + t2.getTotalDuration());
        LinkedHashSet fileIds = Sets.newLinkedHashSet(t1.getFilePath());
        fileIds.addAll(t2.getFilePath());
        result.getFilePath().addAll(fileIds);
        return result;
    }
}

