/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.merge;

import javax.xml.datatype.XMLGregorianCalendar;
import rabbit.data.internal.xml.merge.AbstractMerger;
import rabbit.data.internal.xml.schema.events.TaskFileEventType;
import rabbit.data.internal.xml.schema.events.TaskIdType;

public class TaskFileEventTypeMerger
extends AbstractMerger<TaskFileEventType> {
    @Override
    protected boolean doIsMergeable(TaskFileEventType t1, TaskFileEventType t2) {
        boolean result = false;
        TaskIdType id1 = t1.getTaskId();
        TaskIdType id2 = t2.getTaskId();
        if (id1 != null && id2 != null) {
            result = id1.getHandleId() != null && id2.getHandleId() != null && id1.getHandleId().equals(id2.getHandleId()) && id1.getCreationDate() != null && id2.getCreationDate() != null && id1.getCreationDate().equals(id2.getCreationDate()) && t1.getFilePath() != null && t2.getFilePath() != null && t1.getFilePath().equals(t2.getFilePath());
        }
        return result;
    }

    @Override
    protected TaskFileEventType doMerge(TaskFileEventType t1, TaskFileEventType t2) {
        TaskIdType id = new TaskIdType();
        id.setHandleId(t1.getTaskId().getHandleId());
        id.setCreationDate((XMLGregorianCalendar)t1.getTaskId().getCreationDate().clone());
        TaskFileEventType result = new TaskFileEventType();
        result.setDuration(t1.getDuration() + t2.getDuration());
        result.setFilePath(t1.getFilePath());
        result.setTaskId(id);
        return result;
    }
}

