/* ***********************************************************/
/* Copyright (c) 2010-2016 by Progress Software Corporation       */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

/* this file generates a .w file from the HTML file input */

define input  parameter cPrm            as character no-undo.
define output parameter compileResult    as longchar no-undo.

define variable cHtmlfile       as character no-undo INITIAL "".
define variable cSpeedfile       as character no-undo INITIAL "".
define variable cOutputfile       as character no-undo INITIAL "".
define new shared stream WEBSTREAM.  /** Allow WebSpeed compile */

&GLOBAL-DEFINE COMMAND_SEPARATOR CHR(3)
&GLOBAL-DEFINE OPTION_SEPARATOR CHR(4)

compileResult = "error".

run separateOptions.

do: 
	run webutil/e4gl-gen.r (input cHtmlFile, 
	        input-output cSpeedFile,
	        input-output cOutputfile).    
end.
        
compileResult = "done".    
   
/*
  this section initializes all the variables needed by the compile statement generator
*/
procedure separateOptions.

    define variable i           as integer   no-undo.
    
    define variable OptionCount as integer   no-undo.
    define variable cOption     as character no-undo.
    define variable optName     as character no-undo.
    define variable optValue    as character no-undo.
    
    OptionCount = num-entries(cPrm, {&COMMAND_SEPARATOR}).
    /*
        Should we reset to Unknown. If so we need to use. Whose responsibility to 
        reset this?
    */
    security-policy:xcode-session-key  =  ?.    
    do i = 1 to OptionCount:
        cOption = entry(i, cPrm, {&COMMAND_SEPARATOR}).
        OptName = entry(1, cOption, {&OPTION_SEPARATOR}).
        optValue = entry(2, cOption, {&OPTION_SEPARATOR}).
        case optName:
            when "HTML" then
                do:
                    cHtmlfile = replace(optValue, "~\", "/").                
                end.
            when "WFILE" then
                do:
                    cOutputfile = replace(optValue, "~\", "/").                
                end.
            when "SPEEDFILE" then
               do:
                    cSpeedfile = replace(optValue, "~\", "/").                
                end.
        end case.

    end.
    
end procedure.