/* ***********************************************************/
/* Copyright (c) 1984-2001 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/
/* Author: mattB / PSC                                       */
/*                                                           */
/*************************************************************/
 
/*************************************************************

 Program: webspeed.p
 Purpose: this program handles webrequests from the Progress
          Eclipse Plugin built-in webserver for executing
          webSpeed webojects
          
**************************************************************/          

DEFINE INPUT PARAMETER WebObject as CHARACTER NO-UNDO.
DEFINE INPUT PARAMETER WebData   as CHARACTER NO-UNDO.

DEFINE NEW GLOBAL SHARED VARIABLE OEIDE_Context    AS HANDLE NO-UNDO.

function getServerDirectory returns character (  ) in OEIDE_Context.
function getProjectWorkDirectory returns character 	(  ) in OEIDE_Context.

{src/web/method/cgidefs.i  NEW } /* standard WS cgidefs.i: functions,vars */
{src/web/method/cgiarray.i NEW } /* standard WS cgiarray.i: vars          */ 
{src/web/method/tagmap.i   NEW } /* standard WS tagmap.i: TT tagmap       */
{src/web/method/webutils.i NEW }
DEFINE NEW SHARED VARIABLE server-connection AS CHARACTER NO-UNDO.
DEFINE NEW SHARED VARIABLE transaction-state AS CHARACTER NO-UNDO.

DEFINE VARIABLE hWebStart          AS HANDLE     NO-UNDO.

DEFINE STREAM WebDataIn.

  if SEARCH(webobject) = ? THEN
    RETURN "Web Object File does not exist: " + WebObject.
  if SEARCH(WebData) = ? THEN
    RETURN "Web Data File does not exist: " + WebData.
    
IF NOT VALID-HANDLE(web-utilities-hdl) THEN DO:
  OUTPUT TO VALUE(getProjectWorkDirectory() + "/error.log") UNBUFFERED APPEND. /* Un-trappable Compiler errors */
  RUN VALUE(getServerDirectory() + "_wswebstart.p") PERSISTENT SET hWebStart.
  /* Initialize the tagmap file. */
  RUN reset-tagmap-utilities IN web-utilities-hdl.
  OUTPUT CLOSE.
END.
    

RUN ReadWebData (WebData).

RUN executeWebObject (WebObject) .

APPLY "CLOSE" TO web-utilities-hdl.

/*********** data handling functions */
FUNCTION setHTTPHeader RETURNS LOGICAL
  (INPUT headername as CHARACTER,
  INPUT headervalue as CHARACTER).
  
END FUNCTION.



/******************* Procedures ****************/
PROCEDURE  ReadWebData. 

  DEFINE INPUT PARAMETER WebData as CHARACTER NO-UNDO.

  DEFINE VARIABLE DataType  AS  CHARACTER   NO-UNDO.
  DEFINE VARIABLE DataSize  AS  INTEGER     NO-UNDO.
  DEFINE VARIABLE DataName  AS  CHARACTER   NO-UNDO.
  DEFINE VARIABLE DataValue AS  character  no-undo.

  DEFINE VARIABLE mdata     AS MEMPTR       NO-UNDO.

  INPUT STREAM WebDataIn FROM VALUE(WebData).
  
  REPEAT:
    IMPORT STREAM WebDataIn DELIMITER " "
      DataType DataSize Dataname.
    IMPORT STREAM webdatain UNFORMATTED datavalue.  
    /*set-size(mdata) = DataSize.
    
    if DataSize > 0 then do:
      import stream webdatain unformatted mdata.
      datavalue = get-string(mdata,1).
      SET-SIZE(mdata) = 0.
    end.
    */
    
    CASE DataType:
      WHEN "CGIVALUE":U THEN 
        RUN ReadCGIValue (dataname, datavalue).
      WHEN "HEADER":U THEN
        RUN ReadHeaderValue(dataname, datavalue).
      WHEN "QUERYVALUE":U THEN
        RUN ReadQueryValue(dataname, datavalue).
      WHEN "FORMVALUE":U THEN
        RUN ReadFormValue(dataname, datavalue).
    END CASE.
    
  END.
  
  INPUT STREAM WebDataIn CLOSE.
  
END PROCEDURE.

PROCEDURE executeWebObject.
  DEFINE INPUT PARAMETER WebObject as CHARACTER NO-UNDO.

  DEFINE VARIABLE cMimeCharset       AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE cProCharset        AS CHARACTER  NO-UNDO.
  DEFINE VARIABLE iTest              AS INTEGER    NO-UNDO.
  


  /* Parse the request/CGI from the web server. */
  RUN init-cgi     IN web-utilities-hdl.
  /* Initialize for web-request. */
  RUN init-request IN web-utilities-hdl.

/*
  &IF KEYWORD-ALL("HTML-CHARSET") <> ? &THEN  
  ASSIGN
    cMimeCharset = get-value("wscharset":U)
    cProCharset  = ""
    iTest        = 0.
    
  IF cMimeCharset <> ? AND cMimeCharset <> "" THEN DO:
    /* Confirm receipt of valid MIME character set */
    RUN adecomm/convcp.p (cMimeCharset, "toProg":U, OUTPUT cProCharset) NO-ERROR.
    IF cProCharset = "" THEN DO:
      /*PUT STREAM sLog UNFORMATTED SKIP SUBSTITUTE("The &1 character set has no Progress equivalent.", cMimeCharset). */
    END.
    ELSE DO:
      ASSIGN iTest = ASC("A":U, SESSION:CPINTERNAL, cProCharset) NO-ERROR.
      IF iTest > 0 THEN
        WEB-CONTEXT:HTML-CHARSET = cProCharset.
    END.
    IF iTest >= 0 AND WEB-CONTEXT:HTML-CHARSET <> "" 
      AND WEB-CONTEXT:HTML-CHARSET <> SESSION:CPSTREAM THEN
      OUTPUT {&WEBSTREAM} TO "WEB":U CONVERT TARGET WEB-CONTEXT:HTML-CHARSET.
  END.
  &ENDIF
*/
  
  AppProgram = (IF AppProgram = "debug":U THEN "webutil/debug.p":U ELSE
               (IF AppProgram = "ping":U  THEN "webutil/ping.p":U  ELSE
               (IF AppProgram = "reset":U THEN "webutil/reset.p":U ELSE
                AppProgram))).

  OUTPUT {&WEBSTREAM} TO VALUE(REPLACE(webdata,".webin",".webout")).


/* 
  OUTPUT TO VALUE(cLinkedResources + "\error.log") UNBUFFERED APPEND. /* Un-trappable Compiler errors */
  OUTPUT CLOSE.
 */
  DO ON STOP UNDO, LEAVE ON ERROR UNDO, LEAVE:
    RUN run-web-object IN web-utilities-hdl (AppProgram). 
  END.

  /* Output any pending messages queued up by queue-message() */
  IF available-messages(?) THEN
    output-messages("all", ?, "Messages:").

  /* Output an HTML "... generated by ..." comment at the end of every
     output page but only if HTML is being output. The comment was originally at then beginning of 
     the page but unfortunately IE has a problem with the DOCTYPE not being the first tag
     in standards mode such as XHTML.
  */
  IF CAN-DO ("text/html*,text/x-server-parsed-html*",output-content-type) THEN
    {&OUT} 
      "~n~n<!-- Generated by Webspeed: http://www.webspeed.com/, http://www.possenet.org/ -->~n":U.
  OUTPUT {&WEBSTREAM} CLOSE.


  /* Run clean up and maintenance code and logging */
  RUN end-request IN web-utilities-hdl.

END PROCEDURE.

PROCEDURE ReadHeaderValue.
    DEFINE INPUT  PARAMETER cName AS CHARACTER  NO-UNDO.
    DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
    DEFINE VARIABLE DataLine as CHARACTER NO-UNDO.
    setHTTPHeader(cName, cValue).
END PROCEDURE.

PROCEDURE ReadCGIValue.
    DEFINE INPUT  PARAMETER cName AS CHARACTER  NO-UNDO.
    DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
    RUN addCGI IN web-utilities-hdl (cName, cValue).
END PROCEDURE.

PROCEDURE ReadQueryValue.
    DEFINE INPUT  PARAMETER cName AS CHARACTER  NO-UNDO.
    DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
    RUN addFormGet IN web-utilities-hdl (cname, cValue).
END PROCEDURE.

PROCEDURE ReadFormValue.
    DEFINE INPUT  PARAMETER cName AS CHARACTER  NO-UNDO.
    DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
    RUN addFormPost IN web-utilities-hdl (cName, cValue).
END PROCEDURE.


PROCEDURE ReadCookies.
    DEFINE INPUT  PARAMETER cName AS CHARACTER  NO-UNDO.
    DEFINE INPUT  PARAMETER cValue AS CHARACTER  NO-UNDO.
    RUN addCookie IN web-utilities-hdl (cName, cValue).
END PROCEDURE.

