/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import com.proalpha.pds.jaxb.DsDSConsistencyChecks;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

class ConsistencyChecksImageProvider {
    ConsistencyChecksImageProvider() {
    }

    public Image getDefaultImage() {
        return this.getImageByPriority(BugPriority.YELLOW);
    }

    public Image getImage(Object element) {
        Integer priority = 0;
        if (element instanceof DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck) {
            priority = this.getPriority((DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck)element);
        }
        if (element instanceof DsDSConsistencyChecks.TtDSCheck) {
            priority = this.getPriority((DsDSConsistencyChecks.TtDSCheck)element);
        }
        return this.getImageByPriority(BugPriority.getBugPriority(priority));
    }

    private Image getImageByPriority(BugPriority priority) {
        Image image = null;
        try {
            image = ImageDescriptor.createFromURL((URL)this.getClass().getResource(priority.getImagePath()).toURI().toURL()).createImage();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
        return image;
    }

    private Integer getPriority(DsDSConsistencyChecks.TtDSCheck element) {
        Integer priority = -1;
        for (DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck : element.getTtDSSubCheck()) {
            Integer tempPriority = this.getPriority(subCheck);
            if (priority == -1) {
                priority = tempPriority;
                continue;
            }
            if (tempPriority >= priority) continue;
            priority = tempPriority;
        }
        return priority;
    }

    private Integer getPriority(DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck subCheck) {
        Integer priority = 0;
        List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntrySrc> entriesSrc = subCheck.getTtDSLogEntrySrc();
        if (entriesSrc.size() > 0) {
            priority = entriesSrc.get(0).getLogEntryPriority();
        } else {
            List<DsDSConsistencyChecks.TtDSCheck.TtDSSubCheck.TtDSLogEntryRepos> entriesRepos = subCheck.getTtDSLogEntryRepos();
            if (entriesRepos.size() > 0) {
                priority = entriesRepos.get(0).getLogEntryPriority();
            }
        }
        return priority;
    }

    private static enum BugPriority {
        GREY(0, "/images/bug_grey.png"),
        RED(1, "/images/bug_red.png"),
        YELLOW(2, "/images/bug_yellow.png"),
        GREEN(3, "/images/bug_green.png");

        private Integer value;
        private String imagePath;

        public static BugPriority getBugPriority(Integer value) {
            BugPriority[] priorities = BugPriority.values();
            int i = 0;
            while (i < priorities.length) {
                if (priorities[i].getValue().equals(value)) {
                    return priorities[i];
                }
                ++i;
            }
            return GREY;
        }

        private BugPriority(Integer value, String imagePath) {
            this.value = value;
            this.imagePath = imagePath;
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

