/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchJob;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchOperation;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.SelectBranchesPage;
import com.proalpha.pds.gitutils.mylyn.SelectRepositoryPage;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchWizard
extends Wizard {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchWizard.class);
    private final SelectRepositoryPage repPage;
    private final SelectBranchesPage branchesPage;
    private FeatureBranchSettings settings = new FeatureBranchSettings();

    public FeatureBranchWizard(ITask task) {
        this.settings.setTask(task);
        this.repPage = new SelectRepositoryPage(this.settings);
        this.branchesPage = new SelectBranchesPage(this.settings);
        super.setWindowTitle("proALPHA Feature Branch Generator");
    }

    public boolean performFinish() {
        this.featureBranchAction();
        return true;
    }

    public void addPages() {
        super.addPage((IWizardPage)this.repPage);
        super.addPage((IWizardPage)this.branchesPage);
    }

    public void dispose() {
        super.dispose();
    }

    public FeatureBranchSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FeatureBranchSettings settings) {
        this.settings = settings;
    }

    private void featureBranchAction() {
        FeatureBranchOperation op = new FeatureBranchOperation(this.settings);
        FeatureBranchJob job = new FeatureBranchJob(op);
        job.setUser(true);
        job.setRule(RuleUtil.getRule((Repository)this.settings.getRepository()));
        job.schedule();
    }
}

