/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGit;
import com.proalpha.git.commands.PaIssueConveyanceCommand;
import com.proalpha.git.model.PaCherryPickResult;
import com.proalpha.git.util.PaBranchName;
import com.proalpha.git.util.PaCommitMsg;
import com.proalpha.git.util.PaRepository;
import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.cherrypick.CherryPickOperation;
import com.proalpha.pds.gitutils.cherrypick.CherryPickResultDialog;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.gitutils.common.CheckoutOperation;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CherryPickJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(CherryPickJob.class);
    private int noOfCommits = 0;

    public CherryPickJob(int noOfCommits) {
        super(MessageFormat.format("Cherry picking {0} commits", noOfCommits));
        this.noOfCommits = noOfCommits;
    }

    protected IStatus run(IProgressMonitor monitor) {
        PaIssueConveyanceCommand picCo = CherryPick.getInstance().getCherryPickCommand();
        CherryPickSettings cherryPickSettings = CherryPick.getInstance().getCherryPickSettings();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"pA CherryPick", (int)(this.noOfCommits + 2));
        CherryPickOperation cpOp = new CherryPickOperation(picCo);
        CheckoutOperation coOp = cherryPickSettings.getTargetBranchPoint().startsWith("origin") ? new CheckoutOperation(picCo.getRepository(), "origin", cherryPickSettings.getTargetBranchPoint(), PaBranchName.getShortBranchName((String)picCo.getTargetRef()), cherryPickSettings.isUpdateTargetBranchPoint(), true) : new CheckoutOperation(picCo.getRepository(), PaBranchName.getShortBranchName((String)picCo.getTargetRef()));
        try {
            try {
                progress.setTaskName("Creating the target branch");
                coOp.run();
                progress.worked(1);
                progress.setTaskName("Picking the commits");
                PaGit.getInstance().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(this.noOfCommits)));
                cpOp.execute();
                CherryPick.getInstance().setCherryPickResult(cpOp.getOperationResult());
                CherryPickResult.CherryPickStatus status = CherryPick.getInstance().getCherryPickResult().getStatus();
                if (status != CherryPickResult.CherryPickStatus.OK) {
                    this.setConflictMessage();
                } else {
                    try {
                        PaRepository.disconnectRemote((String)(String.valueOf('_') + cherryPickSettings.getSourceRepoString()));
                    }
                    catch (IOException | GitAPIException e) {
                        this.logger.error("Exception while disconnecting remote {}", (Object)picCo.getSourceRef(), (Object)e);
                    }
                }
                this.showResultDialog(monitor, picCo.getRepository(), CherryPick.getInstance().getCherryPickResult());
            }
            catch (InvocationTargetException | GitAPIException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> CherryPickJob.lambda$0((Exception)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHERRY_PICK.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void setConflictMessage() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            StagingView view = (StagingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.egit.ui.StagingView");
            this.logger.debug("Commit failed: Initialize the commit msg of the git staging view.");
            if (view != null) {
                String msg = PaCommitMsg.getCherryPickMsg((String)CherryPick.getInstance().getCherryPickSettings().getTargetIssue(), (String)((RevCommit)CherryPick.getInstance().getCherryPickResult().getOpenPicks().get(0)).getFullMessage(), (String)((RevCommit)CherryPick.getInstance().getCherryPickResult().getOpenPicks().get(0)).getId().name());
                msg = String.valueOf(msg) + System.getProperty("line.separator");
                msg = String.valueOf(msg) + System.getProperty("line.separator");
                msg = String.valueOf(msg) + "Conflict resolution: DO NOT EDIT THIS MESSAGE";
                view.setCommitMessage(msg);
                view.setFocus();
            }
        });
    }

    private void showResultDialog(IProgressMonitor monitor, Repository repository, PaCherryPickResult cherryPickResult) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            int n = new CherryPickResultDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), monitor, repository, cherryPickResult).open();
        });
    }

    private static /* synthetic */ void lambda$0(Exception exception) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)exception.getCause().getMessage(), (String)exception.getCause().getLocalizedMessage());
    }
}

