/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils;

import com.proalpha.pds.projconf.importwizards.ReadDemasFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.proalpha.pds.gitutils";
    private static MessageConsole console;
    private static final Logger logger;
    private static Activator plugin;

    static {
        logger = LoggerFactory.getLogger(Activator.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow arg0) {
            }

            public void windowDeactivated(IWorkbenchWindow arg0) {
            }

            public void windowClosed(IWorkbenchWindow arg0) {
                ITaskActivityManager taskActivityManager = TasksUi.getTaskActivityManager();
                if (taskActivityManager != null) {
                    taskActivityManager.deactivateActiveTask();
                }
            }

            public void windowActivated(IWorkbenchWindow arg0) {
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static synchronized void logToConsole(String msg) {
        Object consoles;
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (console == null) {
            consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
            IConsole[] iConsoleArray = consoles;
            int n = ((IConsole[])consoles).length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().equals("ABL Console") || console.getName().equals("pA Console")) {
                    Activator.console = (MessageConsole)console;
                }
                ++n2;
            }
            if (console == null) {
                console = new MessageConsole("pA Console", null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            }
        }
        try {
            consoles = null;
            Object var2_8 = null;
            try (MessageConsoleStream consoleStream = console.newMessageStream();){
                consoleStream.println(msg);
            }
            catch (Throwable throwable) {
                if (consoles == null) {
                    consoles = throwable;
                } else if (consoles != throwable) {
                    ((Throwable)consoles).addSuppressed(throwable);
                }
                throw consoles;
            }
        }
        catch (IOException e) {
            logger.warn("Oh no! Exception during writing to console output! {}", (Object)e.getMessage());
        }
    }

    public static String fetchDbCommit(Repository repository) {
        String gitDir = repository.getDirectory().getAbsolutePath().replace(".git", "");
        Path propertyFile = Paths.get(gitDir, "PDSconfig.properties");
        if (new File(propertyFile.toString()).isFile()) {
            return Activator.readCommitInfoFile(new ReadDemasFile(propertyFile.toString()).getClientfolderdb(), "dbinfo");
        }
        return null;
    }

    public static String fetchArtifactsCommit(Repository repository) {
        String gitDir = repository.getDirectory().getAbsolutePath().replace(".git", "");
        Path propertyFile = Paths.get(gitDir, "PDSconfig.properties");
        if (new File(propertyFile.toString()).isFile()) {
            String commitID = Activator.readCommitInfoFile(new ReadDemasFile(propertyFile.toString()).getTempDir().replace("temp", ""), "artifactsinfo");
            if (commitID == null) {
                return Activator.fetchDbCommit(repository);
            }
            return commitID;
        }
        return null;
    }

    private static String readCommitInfoFile(String infoFileFolder, String infoFileName) {
        Path propertyFile = Paths.get(infoFileFolder, infoFileName);
        if (!new File(propertyFile.toString()).isFile()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileReader fr = new FileReader(Paths.get(infoFileFolder, infoFileName).toString());){
                BufferedReader br = new BufferedReader(fr);
                return br.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Couldn't find file {}", (Object)Paths.get(infoFileFolder, infoFileName));
        }
        catch (IOException e) {
            logger.error("Error: {}\n Stack:\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
        }
        return null;
    }
}

