/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.mylyn.ActionResult;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAndBinaryOperation {
    private final Logger logger = LoggerFactory.getLogger(DbAndBinaryOperation.class);
    private Repository repository;
    private ReconcileActionSettings recoActionSettings;
    private List<ActionResult> actionResults = new ArrayList<ActionResult>();
    private SubMonitor monitor;

    public DbAndBinaryOperation(Repository repository, ReconcileActionSettings recoSettings) {
        this.repository = repository;
        this.recoActionSettings = recoSettings;
    }

    public void execute() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ArrayList stages = (ArrayList)DbAndBinaryOperation.this.recoActionSettings.getPaUpdateStages();
                DbAndBinaryOperation.this.monitor.setWorkRemaining(stages.size());
                String gitDir = DbAndBinaryOperation.this.repository.getDirectory().getAbsolutePath();
                File parentDir = new File(gitDir.substring(0, gitDir.lastIndexOf(File.separator)));
                for (String stage : stages) {
                    DbAndBinaryOperation.this.monitor.setTaskName("Running action: " + stage);
                    DbAndBinaryOperation.this.runPaUpdateStage(parentDir, stage, DbAndBinaryOperation.this.monitor.newChild(1));
                }
                File reconcileFile = new File(Paths.get(parentDir.getAbsolutePath(), "reconcile").toString());
                if (reconcileFile.isFile() && !reconcileFile.delete()) {
                    DbAndBinaryOperation.this.logger.error("Could not delete reconcilefile in {}", (Object)reconcileFile);
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)r);
    }

    /*
     * Unable to fully structure code
     */
    private void runPaUpdateStage(File parentDir, String stage, SubMonitor subMonitor) {
        block37: {
            errorMsg = "";
            actionStageResult = new ActionResult(stage);
            builder = new ProcessBuilder(new String[0]);
            builder.command(new String[]{"python", "-u", "-m", "pa_update", "--stage", stage, "--topodir", parentDir.toString(), "--env", "dev"});
            builder.directory(parentDir);
            builder.redirectErrorStream(true);
            builder.redirectInput(ProcessBuilder.Redirect.PIPE);
            builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
            try {
                try {
                    p = builder.start();
                    this.logger.info("Start reconcile action: Running '{}' in {}", builder.command(), (Object)parentDir);
                    var9_10 = null;
                    var10_12 = null;
                    try {
                        rOut = new InputStreamReader(p.getInputStream());
                        try {
                            inOut = new BufferedReader(rOut);
                            try {
                                do {
                                    if ((line = inOut.readLine()) == null) continue;
                                    indexOfFourthSpace = StringUtils.ordinalIndexOf((String)line, (String)" ", (int)4);
                                    if (indexOfFourthSpace > -1) {
                                        subMonitor.setTaskName(line.substring(indexOfFourthSpace));
                                    }
                                    actionStageResult.addToLog(line);
                                    Activator.logToConsole(line);
                                } while (line != null);
                            }
                            finally {
                                if (inOut != null) {
                                    inOut.close();
                                }
                            }
                            ** if (rOut == null) goto lbl-1000
                        }
                        catch (Throwable var10_13) {
                            if (var9_10 == null) {
                                var9_10 = var10_13;
                            } else if (var9_10 != var10_13) {
                                var9_10.addSuppressed(var10_13);
                            }
                            if (rOut != null) {
                                rOut.close();
                            }
                            throw var9_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            rOut.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    catch (Throwable var10_14) {
                        if (var9_10 == null) {
                            var9_10 = var10_14;
                        } else if (var9_10 != var10_14) {
                            var9_10.addSuppressed(var10_14);
                        }
                        throw var9_10;
                    }
                    subMonitor.worked(1);
                    callExitValue = p.waitFor();
                    if (callExitValue <= 0) break block37;
                    rErr = new InputStreamReader(p.getErrorStream());
                    var10_12 = null;
                    var11_16 = null;
                    try {
                        inErr = new BufferedReader(rErr);
                        try {
                            do {
                                if ((line = inErr.readLine()) == null) continue;
                                actionStageResult.addToLog(line);
                                Activator.logToConsole(line);
                            } while (line != null);
                        }
                        finally {
                            if (inErr != null) {
                                inErr.close();
                            }
                        }
                    }
                    catch (Throwable var11_17) {
                        if (var10_12 == null) {
                            var10_12 = var11_17;
                        } else if (var10_12 != var11_17) {
                            var10_12.addSuppressed(var11_17);
                        }
                        throw var10_12;
                    }
                    errorMsg = MessageFormat.format("Error while running stage {0} of python package pa_update with exitcode {1}", new Object[]{stage, callExitValue});
                    Activator.logToConsole(errorMsg);
                    actionStageResult.addToLog(errorMsg);
                    actionStageResult.setStatus("FAIL");
                    this.logger.error("Error while running stage {} of python package pa_update with exitcode {}", (Object)stage, (Object)callExitValue);
                }
                catch (IOException e) {
                    callExitValue = 1;
                    errorMsg = MessageFormat.format("Exception while running stage {0} of python package pa_update with exitcode {1} and {2}", new Object[]{stage, callExitValue, e.getMessage()});
                    actionStageResult.addToLog(errorMsg);
                    actionStageResult.setStatus("FAIL");
                    this.logger.error(errorMsg);
                    subMonitor.done();
                    this.actionResults.add(actionStageResult);
                }
                catch (InterruptedException e) {
                    errorMsg = MessageFormat.format("Error {0} occured", new Object[]{e.getMessage()});
                    actionStageResult.addToLog(errorMsg);
                    actionStageResult.setStatus("FAIL");
                    this.logger.error(errorMsg);
                    Thread.currentThread().interrupt();
                    subMonitor.done();
                    this.actionResults.add(actionStageResult);
                }
            }
            finally {
                subMonitor.done();
                this.actionResults.add(actionStageResult);
            }
        }
    }

    public void setProgressMonitor(SubMonitor monitor) {
        this.monitor = monitor;
    }

    public List<ActionResult> getActionResults() {
        return this.actionResults;
    }
}

