/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.common.DiffOperation;
import com.proalpha.pds.gitutils.mylyn.DeleteRcodeType;
import com.proalpha.pds.gitutils.mylyn.DiffProvider;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.FileNameLabelProvider;
import com.proalpha.pds.gitutils.mylyn.ModifyLabelProvider;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.osgi.framework.Bundle;

public class SelectActionPage
extends WizardPage {
    private FeatureBranchSettings settings;
    private Button btnUpdateStartparameter;
    private Button btnLoadXml;
    private Button btnCreateDf;
    private Button btnLoadDf;
    private Button btnUpdateArtifacts;
    private TableViewer pdiViewer;
    private TableViewer artifactsViewer;
    private Label lblDbCommitId;
    private Label lblDbNewHeadId;
    private Label lblArtifactsCommitId;
    private Label lblArtifNewHeadId;
    private Button btnDelRcodeSmart;
    private Button btnDelRcodeAll;
    private Button btnDelRcodeNone;
    private ReconcileActionSettings recoActionSettings;

    public SelectActionPage(FeatureBranchSettings settings, ReconcileActionSettings recoSettings) {
        super(SelectActionPage.class.getName());
        this.settings = settings;
        this.recoActionSettings = recoSettings;
        this.setTitle("Action Selection");
        this.setMessage("Define reconcile actions to refresh your environment", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setBackgroundMode(1);
        GridData gdGrp = new GridData(4, 4, true, false, 1, 1);
        gdGrp.heightHint = 196;
        gdGrp.widthHint = 450;
        Group dbFilesGrp = new Group(container, 0);
        dbFilesGrp.setLayoutData((Object)gdGrp);
        dbFilesGrp.setText("Update database");
        dbFilesGrp.setBackgroundMode(1);
        this.pdiViewer = new TableViewer((Composite)dbFilesGrp);
        Table pdiTable = this.pdiViewer.getTable();
        pdiTable.setBounds(10, 40, 450, 122);
        TableViewerColumn changeViewerColumn = new TableViewerColumn(this.pdiViewer, 0);
        changeViewerColumn.getColumn().setWidth(40);
        changeViewerColumn.getColumn().setText("Chg");
        changeViewerColumn.getColumn().setAlignment(16384);
        changeViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ModifyLabelProvider()));
        TableViewerColumn fileViewerColumn = new TableViewerColumn(this.pdiViewer, 0);
        fileViewerColumn.getColumn().setWidth(380);
        fileViewerColumn.getColumn().setText("Filename");
        fileViewerColumn.getColumn().setAlignment(16384);
        fileViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FileNameLabelProvider()));
        this.btnLoadXml = new Button((Composite)dbFilesGrp, 32);
        this.btnLoadXml.setText("load Xml");
        this.btnLoadXml.setBounds(5, 170, 68, 16);
        this.btnLoadXml.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionPage.this.recoActionSettings.setLoadXml(SelectActionPage.this.btnLoadXml.getSelection());
            }
        });
        this.btnCreateDf = new Button((Composite)dbFilesGrp, 32);
        this.btnCreateDf.setText("create DF");
        this.btnCreateDf.setBounds(80, 170, 68, 16);
        this.btnCreateDf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionPage.this.recoActionSettings.setCreateDf(SelectActionPage.this.btnCreateDf.getSelection());
            }
        });
        this.btnLoadDf = new Button((Composite)dbFilesGrp, 32);
        this.btnLoadDf.setText("load DF");
        this.btnLoadDf.setBounds(160, 170, 61, 16);
        this.btnLoadDf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionPage.this.recoActionSettings.setLoadDf(SelectActionPage.this.btnLoadDf.getSelection());
            }
        });
        this.btnUpdateStartparameter = new Button((Composite)dbFilesGrp, 32);
        this.btnUpdateStartparameter.setText("update Startparameter");
        this.btnUpdateStartparameter.setBounds(5, 190, 143, 16);
        this.btnUpdateStartparameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionPage.this.recoActionSettings.setUpdateStartparam(SelectActionPage.this.btnUpdateStartparameter.getSelection());
            }
        });
        Label lblDbCommit = new Label((Composite)dbFilesGrp, 0);
        lblDbCommit.setBounds(10, 20, 63, 15);
        lblDbCommit.setText("dbCommit:");
        this.lblDbCommitId = new Label((Composite)dbFilesGrp, 0);
        this.lblDbCommitId.setBounds(72, 20, 70, 15);
        this.lblDbCommitId.setText("");
        Label lblNewHead = new Label((Composite)dbFilesGrp, 0);
        lblNewHead.setBounds(170, 20, 61, 15);
        lblNewHead.setText("new HEAD:");
        this.lblDbNewHeadId = new Label((Composite)dbFilesGrp, 0);
        this.lblDbNewHeadId.setBounds(230, 20, 70, 15);
        this.lblDbNewHeadId.setText("");
        GridData gdCoGrp = new GridData(4, 128, true, false, 1, 1);
        gdCoGrp.heightHint = 142;
        gdCoGrp.widthHint = 450;
        Group artifactsFilesGrp = new Group(container, 0);
        artifactsFilesGrp.setLayoutData((Object)gdCoGrp);
        artifactsFilesGrp.setText("Update artifacts");
        artifactsFilesGrp.setBackgroundMode(1);
        this.artifactsViewer = new TableViewer((Composite)artifactsFilesGrp);
        Table artifactsTable = this.artifactsViewer.getTable();
        artifactsTable.setBounds(15, 40, 450, 94);
        TableViewerColumn artChangeViewerColumn = new TableViewerColumn(this.artifactsViewer, 0);
        TableColumn artChangeTableColumn = artChangeViewerColumn.getColumn();
        artChangeTableColumn.setWidth(40);
        artChangeTableColumn.setText("Chg");
        artChangeViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ModifyLabelProvider()));
        TableViewerColumn artFileViewerColumn = new TableViewerColumn(this.artifactsViewer, 0);
        TableColumn artFileTableColumn = artFileViewerColumn.getColumn();
        artFileTableColumn.setWidth(380);
        artFileTableColumn.setText("Filename");
        artFileTableColumn.setAlignment(16384);
        artFileViewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FileNameLabelProvider()));
        this.btnUpdateArtifacts = new Button((Composite)artifactsFilesGrp, 32);
        this.btnUpdateArtifacts.setBounds(5, 140, 105, 16);
        this.btnUpdateArtifacts.setText("update Artifacts");
        this.btnUpdateArtifacts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectActionPage.this.recoActionSettings.setUpdateArtifacts(SelectActionPage.this.btnUpdateArtifacts.getSelection());
            }
        });
        Label lblArtifactscommit = new Label((Composite)artifactsFilesGrp, 0);
        lblArtifactscommit.setText("artifactsCommit:");
        lblArtifactscommit.setBounds(10, 20, 89, 15);
        this.lblArtifactsCommitId = new Label((Composite)artifactsFilesGrp, 0);
        this.lblArtifactsCommitId.setText("");
        this.lblArtifactsCommitId.setBounds(100, 20, 70, 15);
        Label lblArtifNewHead = new Label((Composite)artifactsFilesGrp, 0);
        lblArtifNewHead.setText("new HEAD:");
        lblArtifNewHead.setBounds(170, 20, 61, 15);
        this.lblArtifNewHeadId = new Label((Composite)artifactsFilesGrp, 0);
        this.lblArtifNewHeadId.setText("");
        this.lblArtifNewHeadId.setBounds(230, 20, 70, 15);
        Group grpUpdateMisc = new Group(container, 0);
        GridData gdGrpUpdateMisc = new GridData(4, 0x1000000, true, false, 1, 1);
        gdGrpUpdateMisc.widthHint = 450;
        gdGrpUpdateMisc.heightHint = 25;
        grpUpdateMisc.setLayoutData((Object)gdGrpUpdateMisc);
        grpUpdateMisc.setText("Delete Rcode");
        grpUpdateMisc.setBackgroundMode(1);
        this.btnDelRcodeSmart = new Button((Composite)grpUpdateMisc, 16);
        this.btnDelRcodeSmart.setBounds(30, 20, 144, 16);
        this.btnDelRcodeSmart.setText("Only wrong (crc check)");
        this.btnDelRcodeAll = new Button((Composite)grpUpdateMisc, 16);
        this.btnDelRcodeAll.setBounds(180, 20, 43, 16);
        this.btnDelRcodeAll.setText("All");
        this.btnDelRcodeAll.setEnabled(false);
        this.btnDelRcodeNone = new Button((Composite)grpUpdateMisc, 16);
        this.btnDelRcodeNone.setText("None");
        this.btnDelRcodeNone.setBounds(229, 20, 50, 16);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initialize();
        }
    }

    private void initialize() {
        if (!this.settings.getDbCommit().isEmpty()) {
            DiffOperation diffOp = new DiffOperation(this.settings.getRepository(), "origin", this.settings.getSourceBranch(), this.settings.getTargetBranch(), this.settings.isUpdateSourceBranch(), this.settings.isUpdateTargetBranch(), this.settings.getDbCommit(), this.settings.getArtifactsCommit());
            try {
                diffOp.run();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.lblArtifNewHeadId.setText(diffOp.getNewHead().substring(0, 10));
            this.lblDbNewHeadId.setText(diffOp.getNewHead().substring(0, 10));
            this.lblDbCommitId.setText(this.settings.getDbCommit().substring(0, 10));
            this.lblArtifactsCommitId.setText(this.settings.getArtifactsCommit().substring(0, 10));
            this.fillTableView(this.pdiViewer, diffOp.getPdiDiffList());
            this.fillTableView(this.artifactsViewer, diffOp.getStateInfoDiffList());
            this.recoActionSettings.deriveFromDiff(diffOp.getPdiDiffList(), diffOp.getStateInfoDiffList());
        }
        this.btnLoadXml.setSelection(this.recoActionSettings.isLoadXml());
        this.btnCreateDf.setSelection(this.recoActionSettings.isCreateDf());
        this.btnLoadDf.setSelection(this.recoActionSettings.isLoadDf());
        this.btnUpdateArtifacts.setSelection(this.recoActionSettings.isUpdateArtifacts());
        this.btnUpdateStartparameter.setSelection(this.recoActionSettings.isUpdateStartparam());
        this.btnDelRcodeSmart.setSelection(this.recoActionSettings.getDeleteRcodeTyper() == DeleteRcodeType.SMART);
        this.btnDelRcodeAll.setSelection(this.recoActionSettings.getDeleteRcodeTyper() == DeleteRcodeType.ALL);
        this.btnDelRcodeNone.setSelection(this.recoActionSettings.getDeleteRcodeTyper() == DeleteRcodeType.NONE);
    }

    private void fillTableView(TableViewer tableViewer, List<DiffEntry> diffList) {
        tableViewer.setContentProvider((IContentProvider)new DiffProvider());
        tableViewer.setInput(diffList);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
    }

    public boolean canFlipToNextPage() {
        return false;
    }
}

