/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.pds.gitutils.pagit.model.server.GitServerRepository;
import com.proalpha.pds.gitutils.pagit.util.bitbucket.BitbucketRestCallGetBranchList;
import com.proalpha.pds.gitutils.pagit.util.bitbucket.BitbucketRestCallGetRepoList;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class BitbucketRestCallTest {
    @Test
    public void testGetRepoListResponse() {
        BitbucketRestCallGetRepoList restcall = new BitbucketRestCallGetRepoList();
        restcall.setSubUrl("repos");
        restcall.execute();
        Assert.assertNotNull((String)"Request is null but it should return a repository list", restcall.getRestResponse());
        ArrayList repos = (ArrayList)restcall.getRestResponse();
        Assert.assertTrue((String)"Request is empty, but should contain a repository list.", (!repos.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetRepoListResponse_shouldCauseNPE() {
        BitbucketRestCallGetRepoList restcall = new BitbucketRestCallGetRepoList();
        restcall.setSubUrl("XXX");
        restcall.execute();
        Assert.assertTrue((boolean)((ArrayList)restcall.getRestResponse()).isEmpty());
    }

    @Test
    public void testGetBranchListResponse() {
        BitbucketRestCallGetBranchList restcall = new BitbucketRestCallGetBranchList();
        restcall.setSubUrl("projects/TEST/repos/unit-test/branches");
        restcall.execute();
        Assert.assertNotNull((String)"Response is null but it should return a branch list", restcall.getRestResponse());
        ArrayList branches = (ArrayList)restcall.getRestResponse();
        Assert.assertTrue((String)"Response is empty but it should contain a branch list", (!branches.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Response should contain master branch but doesn't", (boolean)branches.contains("refs/heads/master"));
    }

    @Test
    public void testGetBranchListResponse_shouldCauseNPE() {
        BitbucketRestCallGetBranchList restcall = new BitbucketRestCallGetBranchList();
        restcall.setSubUrl("projects/XXX/repos/unit-test/branches");
        restcall.execute();
        Assert.assertTrue((boolean)((ArrayList)restcall.getRestResponse()).isEmpty());
    }

    @Test
    public void testLoadRefsOfBitbucketRepository() {
        GitServerRepository testRepo = new GitServerRepository();
        testRepo.setServerType(GitServerRepository.ServerType.BITBUCKET);
        testRepo.setName("unit-test");
        testRepo.setProject("TEST");
        Assert.assertNotNull((String)"The available list of refs is null, but should contain several refs", testRepo.getAvailableRefs());
        Assert.assertTrue((String)"The list of refs should at lease have the master ref", (boolean)testRepo.getAvailableRefs().contains("refs/heads/master"));
    }

    @Test
    public void testLoadRefsOfBitbucketRepository_shouldCauseNPE() {
        GitServerRepository testRepo = new GitServerRepository();
        testRepo.setServerType(GitServerRepository.ServerType.BITBUCKET);
        testRepo.setName("unit-test");
        testRepo.setProject("XXX");
        Assert.assertTrue((boolean)testRepo.getAvailableRefs().isEmpty());
    }
}

