/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.git.tests;

import com.proalpha.git.tests.PaGitTest;
import com.proalpha.pds.gitutils.pagit.exceptions.PaGitGrepException;
import com.proalpha.pds.gitutils.pagit.grep.GitCliGrep;
import com.proalpha.pds.gitutils.pagit.grep.GitGrep;
import com.proalpha.pds.gitutils.pagit.grep.GrepConfig;
import java.io.IOException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PaGitGrepTest {
    private static final String BRANCH = "origin/SearchUnitTest";
    private static GrepConfig config;
    private static GitGrep grep;

    @BeforeClass
    public static void setup() throws IOException, GitAPIException {
        config = new GrepConfig();
        config.setLimit(20);
        config.setBranch(BRANCH);
        config.setSearchScope(GrepConfig.SearchScope.SRC);
        config.setWordBoundaries(false);
        config.setIgnoreCase(true);
    }

    @Test
    public void testSimpleSearchWithMatch() throws IOException, PaGitGrepException {
        String searchTerm = "FINDME";
        config.setSearchScope(GrepConfig.SearchScope.ALL);
        grep = new GitCliGrep(PaGitTest.TMP_GIT_DIRECTORY, searchTerm, config);
        Assert.assertEquals((long)3L, (long)grep.getResults().size());
    }

    @Test
    public void testSimpleSearchWithoutMatch() throws IOException, PaGitGrepException {
        String searchTerm = "NonExistingTerm";
        grep = new GitCliGrep(PaGitTest.TMP_GIT_DIRECTORY, searchTerm, config);
        Assert.assertEquals((long)0L, (long)grep.getResults().size());
    }

    @Test
    public void testSimplePDISearch() throws IOException, PaGitGrepException {
        GrepConfig.SearchScope sc = config.getSearchScope();
        try {
            String searchTerm = "a_afa00003";
            config.setSearchScope(GrepConfig.SearchScope.PDI);
            grep = new GitCliGrep(PaGitTest.TMP_GIT_DIRECTORY, searchTerm, config);
            Assert.assertEquals((long)2L, (long)grep.getResults().size());
        }
        finally {
            config.setSearchScope(sc);
        }
    }
}

