/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.CheckoutAction;
import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import com.proalpha.pds.gitutils.pagit.util.PaRepository;
import java.util.List;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITask;

public class FeatureBranchSettings {
    private ITask task;
    private Repository repository;
    private String taskEpic = "";
    private String taskSprint = "";
    private String taskParent = "";
    private String targetBranch;
    private String sourceBranch;
    private String dbCommit = "";
    private String artifactsCommit = "";
    private boolean updateTargetBranch = true;
    private boolean updateSourceBranch = true;
    private CheckoutAction checkoutAction = CheckoutAction.LOAD_XML;

    public CheckoutAction getCheckoutAction() {
        return this.checkoutAction;
    }

    public void setCheckoutAction(CheckoutAction checkoutAction) {
        this.checkoutAction = checkoutAction;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isUpdateTargetBranch() {
        return this.updateTargetBranch;
    }

    public void setUpdateTargetBranch(boolean updateTargetBranch) {
        this.updateTargetBranch = updateTargetBranch;
    }

    public boolean isUpdateSourceBranch() {
        return this.updateSourceBranch;
    }

    public void setUpdateSourceBranch(boolean updateSourceBranch) {
        this.updateSourceBranch = updateSourceBranch;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public ITask getTask() {
        return this.task;
    }

    public void setTask(ITask task) {
        this.task = task;
    }

    public String getTaskEpic() {
        return this.taskEpic;
    }

    public void setTaskEpic(String taskEpic) {
        this.taskEpic = taskEpic;
    }

    public String getTaskSprint() {
        return this.taskSprint;
    }

    public void setTaskSprint(String taskSprint) {
        this.taskSprint = taskSprint;
    }

    public String getTaskParent() {
        return this.taskParent;
    }

    public void setTaskParent(String taskParent) {
        this.taskParent = taskParent;
    }

    public String getDbCommit() {
        return this.dbCommit;
    }

    public void setDbCommit(String dbCommit) {
        this.dbCommit = dbCommit;
    }

    public String getArtifactsCommit() {
        return this.artifactsCommit;
    }

    public void setArtifactsCommit(String artifactsCommit) {
        this.artifactsCommit = artifactsCommit;
    }

    public void deriveDefaults() {
        this.deriveDefaultSourceBranch();
        this.deriveDefaultTargetBranch();
    }

    public void deriveDefaultSourceBranch() {
        List<String> branches = PaRepository.getMasterBranches(this.getRepository());
        if (!branches.isEmpty()) {
            String version = PaBranchName.getVersion(branches.get(0), this.getRepository());
            if (version != null) {
                this.setSourceBranch(String.valueOf(version) + ".master");
                return;
            }
        } else {
            String version;
            branches = PaRepository.getCodeFreezeBranches(this.getRepository());
            if (!branches.isEmpty() && (version = PaBranchName.getVersion(branches.get(0), this.getRepository())) != null) {
                this.setSourceBranch(version);
                return;
            }
        }
        this.setSourceBranch("master");
    }

    public void deriveTargetBranch(String branchSuffix) {
        String version = "";
        List<String> branches = PaRepository.getMasterBranches(this.getRepository());
        if (branches.isEmpty()) {
            branches = PaRepository.getCodeFreezeBranches(this.getRepository());
        }
        if (!branches.isEmpty() && (version = PaBranchName.getVersion(branches.get(0), this.getRepository())) != null) {
            this.setTargetBranch(String.valueOf(version) + "." + branchSuffix);
            return;
        }
        this.setTargetBranch(branchSuffix);
    }

    public void deriveDefaultTargetBranch() {
        this.deriveTargetBranch(this.task.getTaskKey());
    }
}

