/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaGitConfig {
    private static final Logger logger = LoggerFactory.getLogger(PaGitConfig.class);
    private static final String CONFIG_FILE = "config.json";
    private static Map<String, Object> config = null;

    private PaGitConfig() {
    }

    private static Map<String, Object> loadConfig(String path) {
        HashMap config;
        block27: {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Loading config file: %s.", path));
            }
            config = new HashMap();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileReader fr22 = new FileReader(path);){
                    config = (HashMap)new ObjectMapper().readValue((Reader)fr22, HashMap.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                try {
                    Throwable throwable = null;
                    Object fr22 = null;
                    try (FileReader fr = new FileReader("resources/" + path);){
                        config = (HashMap)new ObjectMapper().readValue((Reader)fr, HashMap.class);
                    }
                    catch (Throwable fr22) {
                        if (throwable == null) {
                            throwable = fr22;
                        } else if (throwable != fr22) {
                            throwable.addSuppressed(fr22);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    try {
                        InputStream is = PaGitConfig.class.getClassLoader().getResourceAsStream(path);
                        config = (HashMap)new ObjectMapper().readValue(is, HashMap.class);
                    }
                    catch (IOException e3) {
                        try {
                            InputStream is = PaGitConfig.class.getClassLoader().getResourceAsStream("resources/" + path);
                            config = (HashMap)new ObjectMapper().readValue(is, HashMap.class);
                        }
                        catch (IOException e4) {
                            if (!logger.isErrorEnabled()) break block27;
                            logger.error("Could not load config file", (Object)path, (Object)e4);
                        }
                    }
                }
            }
        }
        return config;
    }

    private static void init() {
        config = PaGitConfig.loadConfig(CONFIG_FILE);
    }

    public static void loadFileConfig(String path) {
        if (config == null) {
            PaGitConfig.init();
        }
        Map<String, Object> fileConfig = PaGitConfig.loadConfig(path);
        config.putAll(fileConfig);
    }

    private static Object getObject(Map<String, Object> cfg, String key) {
        if (cfg == null) {
            return null;
        }
        if (!key.contains(".")) {
            if (cfg.containsKey(key)) {
                return cfg.get(key);
            }
            return null;
        }
        String currLevel = key.substring(0, key.indexOf(46));
        String nextLevel = key.substring(key.indexOf(46) + 1);
        if (!cfg.containsKey(currLevel) || !(cfg.get(currLevel) instanceof HashMap)) {
            return null;
        }
        return PaGitConfig.getObject((HashMap)cfg.get(currLevel), nextLevel);
    }

    private static Object getObject(String key) {
        return PaGitConfig.getObject(config, key);
    }

    public static String getStringFromConfig(String key) {
        Object obj;
        if (config == null) {
            PaGitConfig.init();
        }
        if ((obj = PaGitConfig.getObject(key)) instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public static List<String> getListFromConfig(String key) {
        Object obj;
        if (config == null) {
            PaGitConfig.init();
        }
        if ((obj = PaGitConfig.getObject(key)) instanceof ArrayList) {
            List list = (List)obj;
            return list;
        }
        return new ArrayList<String>();
    }

    public static Integer getIntFromConfig(String key) {
        Object obj;
        if (config == null) {
            PaGitConfig.init();
        }
        if ((obj = PaGitConfig.getObject(key)) instanceof Integer) {
            return (Integer)obj;
        }
        return null;
    }
}

