/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.commands;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.commands.PaCherryPickCommand;
import com.proalpha.pds.gitutils.pagit.exceptions.PaCherryPickException;
import com.proalpha.pds.gitutils.pagit.model.grep.PaCherryPickResult;
import com.proalpha.pds.gitutils.pagit.util.PaIssueExplorer;
import com.proalpha.pds.gitutils.pagit.util.PaRepository;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaIssueConveyanceCommand
extends GitCommand<PaCherryPickResult> {
    protected final Logger logger = LoggerFactory.getLogger(PaIssueConveyanceCommand.class);
    private String sourceRef = null;
    private String targetRef = null;
    private String issue = null;
    private String targetIssue = "";
    private boolean updateSourceRef = false;
    private PaCherryPickCommand cp = null;

    public PaIssueConveyanceCommand() {
        super(PaGit.getInstance().getGit().getRepository());
        this.setCallable(false);
    }

    private void setCallable() {
        this.setCallable(this.sourceRef != null && this.targetRef != null && this.issue != null);
    }

    public String getSourceRef() {
        return this.sourceRef;
    }

    public PaIssueConveyanceCommand setSourceRef(String sourceBranch) {
        this.sourceRef = sourceBranch;
        this.setCallable();
        return this;
    }

    public String getTargetRef() {
        return this.targetRef;
    }

    public PaIssueConveyanceCommand setTargetRef(String targetBranch) {
        this.targetRef = targetBranch;
        this.setCallable();
        return this;
    }

    public String getIssue() {
        return this.issue;
    }

    public PaIssueConveyanceCommand setIssue(String issue) {
        this.issue = issue;
        this.setCallable();
        return this;
    }

    public String getTargetIssue() {
        return this.targetIssue;
    }

    public PaIssueConveyanceCommand setTargetIssue(String targetIssue) {
        this.targetIssue = targetIssue;
        return this;
    }

    public boolean isUpdateSourceRef() {
        return this.updateSourceRef;
    }

    public PaIssueConveyanceCommand setUpdateSourceRef(boolean updateSourceRef) {
        this.updateSourceRef = updateSourceRef;
        return this;
    }

    private void checkRepository() throws PaCherryPickException {
        if (!PaRepository.isValidRef(this.sourceRef)) {
            throw new PaCherryPickException("The source ref is no valid git reference!");
        }
        if (!PaRepository.isRemoteTrackingBranch(this.sourceRef) && this.updateSourceRef) {
            throw new PaCherryPickException("The source ref is no remote-tracking branch and can not be updated automatically.");
        }
        if (this.getRepository().getRepositoryState() != RepositoryState.SAFE) {
            throw new PaCherryPickException("The repository is currently in a state, which does not allow a cherry-pick operation.\nIf there was a conflict, you have to solve the conflict by hand before being able to resume the cherry-pick.");
        }
    }

    public PaCherryPickResult call() throws GitAPIException {
        this.checkCallable();
        this.checkRepository();
        try {
            if (this.cp == null) {
                if (this.updateSourceRef) {
                    PaRepository.updateBranch(this.sourceRef);
                }
                List<RevCommit> commits = PaIssueExplorer.getCommitsOfIssue(this.sourceRef, this.issue);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Convey issue %s to branch %s by applying following commits: ", this.issue, this.targetRef), commits);
                }
                this.cp = new PaCherryPickCommand();
                this.cp.setCommits(commits);
                this.cp.setTargetRef(this.targetRef);
                this.cp.setTargetIssue(this.targetIssue);
            } else {
                this.cp.skipNextCommit();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Resuming conveyance of issue %s to branch %s.", this.issue, this.targetRef));
                }
            }
            return this.cp.call();
        }
        catch (IOException e) {
            throw new PaCherryPickException("Issue conveyance failed due to a general IOException. Something went really wrong!");
        }
    }

    public void rollback() throws GitAPIException, IOException {
        if (this.cp != null) {
            this.cp.rollback();
        }
    }
}

