/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.example;

import com.proalpha.pds.gitutils.pagit.exceptions.PaGitGrepException;
import com.proalpha.pds.gitutils.pagit.grep.GitCliGrep;
import com.proalpha.pds.gitutils.pagit.grep.GrepConfig;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitGrepExample {
    protected static final Logger logger = LoggerFactory.getLogger(GitGrepExample.class);
    private static final String REPOSITORY = "D:\\Projekte\\ide_test\\71c01\\proalpha\\.git";

    public static void main(String[] args) {
        try {
            logger.info("Start");
            long start = System.currentTimeMillis();
            GrepConfig config = new GrepConfig();
            String searchTerm = "-e \"def c\" --and -e Jira";
            config.setLimit(10);
            config.setBranch("71.master");
            config.setFileFilter("**.py");
            config.setSearchScope(GrepConfig.SearchScope.SRC);
            config.setWordBoundaries(false);
            config.setIgnoreCase(true);
            String repositoryPath = REPOSITORY;
            GitCliGrep cliGrep = new GitCliGrep(repositoryPath, searchTerm, config);
            logger.info("CLI grep: Number of results = {} ", (Object)cliGrep.getResults().size());
            cliGrep.printResults(false);
            if (logger.isInfoEnabled()) {
                logger.info("End: {} ", (Object)Long.toString(System.currentTimeMillis() - start));
            }
        }
        catch (PaGitGrepException | IOException e) {
            logger.error("", (Throwable)e);
        }
    }
}

