/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util;

import com.proalpha.pds.gitutils.pagit.PaGitConfig;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaCommitMsg {
    protected static final Logger logger = LoggerFactory.getLogger(PaCommitMsg.class);
    private static final String CP_COMMIT_SUFFIX = "(cherry picked from commit %s)";
    private static final String CP_COMMIT_SUFFIX_REGEX = "\\(cherry picked from commit ([0-9a-f]*)\\)";

    private PaCommitMsg() {
    }

    public static String getIssueKeyFromCommitMsg(RevCommit commit) {
        String msg = commit.getFullMessage();
        Pattern p = Pattern.compile("^(" + PaGitConfig.getStringFromConfig("issue_key_format") + ").*", 32);
        Matcher m = p.matcher(msg);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public static boolean isCommitMsgWithIssueKey(RevCommit commit) {
        String key = PaCommitMsg.getIssueKeyFromCommitMsg(commit);
        if (key == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Following msg has INVALID format: {}", (Object)commit.getFullMessage());
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Following msg has valid format: {}", (Object)commit.getFullMessage());
        }
        return true;
    }

    public static String getCherryPickMsg(String issue, String origCommitMsg, String commitId) {
        if (PaCommitMsg.isCherryPickMsg(issue, origCommitMsg)) {
            return origCommitMsg;
        }
        return String.valueOf(PaCommitMsg.getCherryPickedFromString(issue, commitId)) + System.getProperty("line.separator") + origCommitMsg;
    }

    public static String getCherryPickedFromString(String commitId) {
        return String.format(CP_COMMIT_SUFFIX, commitId);
    }

    public static String getCherryPickedFromString(String issue, String commitId) {
        return String.format("%s:\n(cherry picked from commit %s)", issue, commitId);
    }

    public static String getIdFromCherryPickMsg(String msg) {
        Matcher m = Pattern.compile(CP_COMMIT_SUFFIX_REGEX).matcher(msg);
        m.find();
        return m.group(1);
    }

    public static boolean isCherryPickMsg(String issue, String msg) {
        Matcher m = Pattern.compile("\\A(?i)" + issue + ":\\s" + CP_COMMIT_SUFFIX_REGEX).matcher(msg);
        return m.find();
    }
}

