/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util;

import com.proalpha.pds.gitutils.pagit.PaGit;
import com.proalpha.pds.gitutils.pagit.util.GitServerNameUtil;
import com.proalpha.pds.gitutils.pagit.util.PaBranchName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaRepository {
    private static final Logger logger = LoggerFactory.getLogger(PaRepository.class);

    private PaRepository() {
    }

    public static FetchResult updateBranch(String ref) throws GitAPIException {
        RefSpec refSpec = null;
        String remote = null;
        if (logger.isDebugEnabled()) {
            try {
                logger.debug(String.format("Update branch %s. Current commit: %s.", ref, PaGit.getInstance().getGit().getRepository().resolve(ref) != null ? PaGit.getInstance().getGit().getRepository().resolve(ref).name() : null));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (PaRepository.isRemoteTrackingBranch(ref)) {
            remote = PaGit.getInstance().getGit().getRepository().getRemoteName(ref);
            String branchName = PaGit.getInstance().getGit().getRepository().shortenRemoteBranchName(ref);
            refSpec = new RefSpec(String.format("+refs/heads/%s:%s", branchName, ref));
        } else {
            StoredConfig repoConfig = PaGit.getInstance().getGit().getRepository().getConfig();
            BranchConfig branchConfig = new BranchConfig((Config)repoConfig, PaBranchName.getShortBranchName(ref));
            remote = branchConfig.getRemote();
            refSpec = new RefSpec(String.format("+refs/heads/%s:refs/remotes/%s", PaRepository.getLocalServerBranch(ref), PaRepository.getRemoteTrackingBranch(ref)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Fetching from: %s.", remote));
            logger.debug(String.format("Used RefSpec for fetch operation: %s.", refSpec.toString()));
        }
        FetchCommand fetch = PaGit.getInstance().getGit().fetch();
        fetch.setRemote(remote);
        fetch.setRefSpecs(new RefSpec[]{refSpec});
        if (PaGit.getInstance().getProgressMonitor() != null) {
            fetch.setProgressMonitor(PaGit.getInstance().getProgressMonitor());
        }
        if (PaGit.getInstance().getCredentialProvider() != null) {
            fetch.setCredentialsProvider(PaGit.getInstance().getCredentialProvider());
        }
        return fetch.call();
    }

    public static String connectRemoteBranch(String repoUrl, String branch, String remoteName) throws IOException, GitAPIException {
        String remote = PaRepository.getRemoteName(repoUrl);
        if (remote == null) {
            remote = remoteName;
            StoredConfig config = PaGit.getInstance().getGit().getRepository().getConfig();
            config.setString("remote", remote, "url", repoUrl);
            String refSpec = "+refs/heads/" + branch + ":" + "refs/remotes/" + remote + "/" + branch;
            config.setString("remote", remote, "fetch", refSpec);
            config.save();
        }
        String ref = "refs/remotes/" + remote + "/" + branch;
        PaRepository.updateBranch(ref);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Remote branch is now available with ref %s.", ref));
        }
        return ref;
    }

    public static String connectRemoteBranch(String repoUrl, String branch) throws GitAPIException, IOException {
        String name = GitServerNameUtil.getRepositoryFromUrl(repoUrl);
        name = "_" + name;
        return PaRepository.connectRemoteBranch(repoUrl, branch, name);
    }

    public static void disconnectRemote(String remote) throws IOException, GitAPIException {
        for (Ref ref : PaGit.getInstance().getGit().branchList().setListMode(ListBranchCommand.ListMode.ALL).call()) {
            if (!ref.getName().startsWith("refs/remotes/" + remote + "/")) continue;
            PaGit.getInstance().getGit().branchDelete().setForce(true).setBranchNames(new String[]{ref.getName()}).call();
        }
        StoredConfig config = PaGit.getInstance().getGit().getRepository().getConfig();
        config.unsetSection("remote", remote);
        config.save();
    }

    private static String getRemoteName(String repoUrl) {
        StoredConfig config = PaGit.getInstance().getGit().getRepository().getConfig();
        Set allRemotes = config.getSubsections("remote");
        for (String remote : allRemotes) {
            if (!repoUrl.equals(config.getString("remote", remote, "url"))) continue;
            return remote;
        }
        return null;
    }

    public static String getRemoteTrackingBranch(Repository rep, String ref) {
        if (!PaRepository.isValidRef(rep, ref)) {
            return null;
        }
        if (PaRepository.isRemoteTrackingBranch(rep, ref)) {
            return PaBranchName.getBranchName(ref);
        }
        StoredConfig repoConfig = rep.getConfig();
        BranchConfig branchConfig = new BranchConfig((Config)repoConfig, PaBranchName.getShortBranchName(ref, rep));
        String remoteTrackingRef = branchConfig.getRemoteTrackingBranch();
        if (remoteTrackingRef != null) {
            return PaBranchName.getBranchName(remoteTrackingRef);
        }
        remoteTrackingRef = "origin/" + PaBranchName.getShortBranchName(ref, rep);
        if (PaRepository.isValidRef(rep, remoteTrackingRef)) {
            return remoteTrackingRef;
        }
        return null;
    }

    public static String getRemoteTrackingBranch(String ref) {
        return PaRepository.getRemoteTrackingBranch(PaGit.getInstance().getGit().getRepository(), ref);
    }

    public static String getLocalServerBranch(String ref) {
        if (!PaRepository.isValidRef(ref)) {
            return null;
        }
        if (PaRepository.isRemoteTrackingBranch(ref)) {
            return PaBranchName.getShortBranchName(ref);
        }
        StoredConfig repoConfig = PaGit.getInstance().getGit().getRepository().getConfig();
        BranchConfig branchConfig = new BranchConfig((Config)repoConfig, PaBranchName.getShortBranchName(ref));
        String mergeBranch = branchConfig.getMerge();
        if (mergeBranch != null) {
            return PaBranchName.getBranchName(mergeBranch);
        }
        return null;
    }

    public static boolean isValidRef(String ref) {
        return PaRepository.isValidRef(PaGit.getInstance().getGit().getRepository(), ref);
    }

    public static boolean isValidRef(Repository rep, String ref) {
        try {
            return rep.resolve(ref) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isRemoteTrackingBranch(String ref) {
        return PaRepository.isRemoteTrackingBranch(PaGit.getInstance().getGit().getRepository(), ref);
    }

    public static boolean isRemoteTrackingBranch(Repository rep, String ref) {
        if (ref.startsWith("refs/remotes/")) {
            return true;
        }
        for (String remote : rep.getRemoteNames()) {
            if (!ref.startsWith(String.valueOf(remote) + "/") && !ref.startsWith("remotes/" + remote + "/")) continue;
            return true;
        }
        return false;
    }

    public static String getBranchOfCommit(Repository rep, RevCommit commit) {
        block16: {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (Git git = new Git(rep);){
                    Map nRevComm = git.nameRev().addPrefix("refs/heads/").add((ObjectId)commit).call();
                    if (nRevComm != null && nRevComm.get(commit.getId()) != null) {
                        return (String)nRevComm.get(commit.getId());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GitAPIException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("A GitAPIException occured while calling NameRevCommand:", (Throwable)e);
                }
            }
            catch (MissingObjectException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("A MissingObjectException occured while calling NameRevCommand:", (Throwable)e);
                }
            }
            catch (JGitInternalException e) {
                if (!logger.isErrorEnabled()) break block16;
                logger.error("A JGitInternalException occured while calling NameRevCommand:", (Throwable)e);
            }
        }
        return null;
    }

    public static String getBranchOfCommit(RevCommit commit) {
        return PaRepository.getBranchOfCommit(PaGit.getInstance().getGit().getRepository(), commit);
    }

    public static List<String> getLocalBranches(Repository rep) {
        ArrayList<String> branches;
        block12: {
            branches = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Git git = new Git(rep);){
                    List refs = git.branchList().call();
                    for (Ref ref : refs) {
                        branches.add(PaBranchName.getShortBranchName(ref.getName(), rep));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GitAPIException e) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("A GitAPIException occured while calling branchList command:", (Throwable)e);
            }
        }
        return branches;
    }

    public static List<String> getRemoteBranches() {
        return PaRepository.getRemoteBranches(PaGit.getInstance().getGit().getRepository());
    }

    public static List<String> getRemoteBranches(Repository rep) {
        ArrayList<String> branches;
        block12: {
            branches = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Git git = new Git(rep);){
                    List refs = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                    for (Ref ref : refs) {
                        branches.add(PaBranchName.getShortBranchName(ref.getName(), rep));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GitAPIException e) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("A GitAPIException occured while calling branchList command:", (Throwable)e);
            }
        }
        return branches;
    }

    public static List<String> getLocalBranches() {
        return PaRepository.getLocalBranches(PaGit.getInstance().getGit().getRepository());
    }

    public static List<String> getMasterBranches(Repository rep) {
        ArrayList<String> branches;
        block12: {
            branches = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Git git = new Git(rep);){
                    List refs = git.branchList().call();
                    for (Ref ref : refs) {
                        if (!PaBranchName.isMasterBranch(ref.getName(), rep)) continue;
                        branches.add(PaBranchName.getShortBranchName(ref.getName(), rep));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GitAPIException e) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("A GitAPIException occured while calling branchList command:", (Throwable)e);
            }
        }
        return branches;
    }

    public static List<String> getMasterBranches() {
        return PaRepository.getMasterBranches(PaGit.getInstance().getGit().getRepository());
    }

    public static List<String> getCodeFreezeBranches(Repository rep) {
        ArrayList<String> branches;
        block12: {
            branches = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Git git = new Git(rep);){
                    List refs = git.branchList().call();
                    for (Ref ref : refs) {
                        if (!PaBranchName.isCodeFreezeBranch(ref.getName(), rep)) continue;
                        branches.add(PaBranchName.getShortBranchName(ref.getName(), rep));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GitAPIException e) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("A GitAPIException occured while calling branchList command:", (Throwable)e);
            }
        }
        return branches;
    }

    public static List<String> getCodeFreezeBranches() {
        return PaRepository.getCodeFreezeBranches(PaGit.getInstance().getGit().getRepository());
    }
}

