/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.pagit.util.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.HttpResponse;
import com.proalpha.pds.gitutils.pagit.model.server.BitbucketBranch;
import com.proalpha.pds.gitutils.pagit.model.server.BitbucketRestBranchListResponse;
import com.proalpha.pds.gitutils.pagit.util.bitbucket.BitbucketRestCall;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketRestCallGetBranchList
extends BitbucketRestCall<ArrayList<String>> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketRestCallGetBranchList.class);

    @Override
    protected ArrayList<String> parseRestResponse(HttpResponse response) throws IOException {
        ArrayList<String> branchList = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = response.getContent();){
                BitbucketRestBranchListResponse resp = (BitbucketRestBranchListResponse)new ObjectMapper().readValue(in, BitbucketRestBranchListResponse.class);
                for (BitbucketBranch branch : resp.getValues()) {
                    this.logger.debug("Add Branch: {}", (Object)branch.getId());
                    branchList.add(branch.getId());
                }
                if (!resp.getIsLastPage().booleanValue()) {
                    this.setStartEntry(resp.getNextPageStart());
                    this.execute();
                    branchList.addAll((Collection)this.getRestResponse());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NullPointerException e) {
            this.logger.debug("NPE occured, due to empty http-response {}", (Object)e.getMessage());
        }
        return branchList;
    }
}

