/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.ActionResult;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionResultDialog
extends Dialog {
    private final Logger logger = LoggerFactory.getLogger(ActionResultDialog.class);
    private final List<ActionResult> results;
    private String status = "OK";

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(main);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        main.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(main, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("Result Status:");
        Text text = new Text(composite, 8);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        text.setText(this.status);
        text.setFont(JFaceResources.getFont((String)"Courier New"));
        if (this.status.equalsIgnoreCase("OK")) {
            text.setForeground(parent.getDisplay().getSystemColor(6));
        } else {
            text.setForeground(parent.getDisplay().getSystemColor(3));
        }
        Group grpPerformedActions = new Group(main, 0);
        grpPerformedActions.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpPerformedActions.setText("Performed Actions");
        TreeViewer succViewer = new TreeViewer((Composite)grpPerformedActions);
        Tree succTree = succViewer.getTree();
        succTree.setBounds(5, 20, 460, 250);
        this.fillTreeView(succViewer, this.results);
        return main;
    }

    public ActionResultDialog(Shell parentShell, List<ActionResult> results) {
        super(parentShell);
        this.results = results;
        for (ActionResult result : results) {
            if (result.getStatus().equalsIgnoreCase("OK")) continue;
            this.status = "WARNING";
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Checkout Result: " + this.status);
    }

    private void fillTreeView(TreeViewer treeViewer, List<ActionResult> results) {
        TreeViewerColumn treeViewerColumnStatus = new TreeViewerColumn(treeViewer, 0);
        TreeColumn trclmnNewColumnStatus = treeViewerColumnStatus.getColumn();
        trclmnNewColumnStatus.setWidth(75);
        trclmnNewColumnStatus.setText("Status");
        treeViewerColumnStatus.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StatusLabelProvider()));
        TreeViewerColumn treeViewerColumnAction = new TreeViewerColumn(treeViewer, 0);
        TreeColumn trclmnNewColumnAction = treeViewerColumnAction.getColumn();
        trclmnNewColumnAction.setWidth(600);
        trclmnNewColumnAction.setText("Action");
        trclmnNewColumnAction.setAlignment(16384);
        treeViewerColumnAction.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ActionLabelProvider()));
        treeViewer.setContentProvider((IContentProvider)new ResultProvider());
        treeViewer.setInput(results);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
    }

    class ActionLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        ActionLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof ActionResult) {
                ActionResult result = (ActionResult)element;
                return new StyledString(result.getAction());
            }
            if (element instanceof String) {
                return new StyledString(this.getShortLog((String)element));
            }
            return null;
        }

        private String getShortLog(String logLine) {
            Pattern p = Pattern.compile("([\\d-]+) ([\\d:]+)([,\\d]+) (DEBUG|WARNING|ERROR|INFO) \\[(.*?)\\] (.*)");
            Matcher m = p.matcher(logLine);
            if (m.find()) {
                return m.group(6);
            }
            return logLine;
        }
    }

    public class ResultProvider
    implements ITreeContentProvider {
        private final Object[] emptyArray = new Object[0];

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return this.emptyArray;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ActionResult) {
                ActionResult result = (ActionResult)parentElement;
                return result.getLog().toArray();
            }
            return this.emptyArray;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ActionResult) {
                ActionResult result = (ActionResult)element;
                return !result.getLog().isEmpty();
            }
            return false;
        }
    }

    class StatusLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        StatusLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof ActionResult) {
                ActionResult result = (ActionResult)element;
                return new StyledString(result.getStatus());
            }
            if (element instanceof String) {
                return new StyledString("LOG");
            }
            return null;
        }
    }
}

