/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.RepositoryFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectRepositoryPage
extends WizardPage {
    private final Logger logger = LoggerFactory.getLogger(SelectRepositoryPage.class);
    private FeatureBranchSettings settings;
    private RepositoryFilter searchFilter;
    private CheckboxTableViewer repositoryViewer;
    private ICheckStateListener checkRepositoryStateListener;

    public SelectRepositoryPage(FeatureBranchSettings settings) {
        super(SelectRepositoryPage.class.getName());
        this.settings = settings;
        this.setTitle("Repository Selection");
        this.setMessage("If no repository is selected, the task will be activated without repository action.", 1);
        this.setDescription("Desc Select the repository");
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
        this.searchFilter = new RepositoryFilter(settings.getTask());
    }

    private void createFilterText(Group repositoryGroup) {
        final Text filterText = new Text((Composite)repositoryGroup, 896);
        filterText.setLayoutData((Object)new GridData(768));
        filterText.setMessage("type to filter the repositories shown");
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SelectRepositoryPage.this.searchFilter.setSearchText(filterText.getText());
                RepositoryNode activeRepositoryNode = SelectRepositoryPage.this.getActiveRepositoryNode();
                SelectRepositoryPage.this.repositoryViewer.refresh();
                SelectRepositoryPage.this.checkIfRepositoryStillInView(activeRepositoryNode);
            }
        });
    }

    private RepositoryNode getActiveRepositoryNode() {
        RepositoryNode returnValue = null;
        Object[] activeRepositoryNodes = this.repositoryViewer.getCheckedElements();
        if (activeRepositoryNodes.length > 0) {
            returnValue = (RepositoryNode)activeRepositoryNodes[0];
        }
        return returnValue;
    }

    private void checkIfRepositoryStillInView(RepositoryNode activeRepositoryNode) {
        if (activeRepositoryNode != null) {
            TableItem[] tableItemArray = this.repositoryViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData().equals(activeRepositoryNode)) {
                    return;
                }
                ++n2;
            }
            this.setNoRepositorySelected();
        }
    }

    private void createButtonShowAllProjects(Group repositoryGroup) {
        Button showAllProjectsButton = new Button((Composite)repositoryGroup, 32);
        showAllProjectsButton.setText("Show all Repositories");
        showAllProjectsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SelectRepositoryPage.this.searchFilter.setShowAllProjects(((Button)event.widget).getSelection());
                RepositoryNode activeRepositoryNode = SelectRepositoryPage.this.getActiveRepositoryNode();
                SelectRepositoryPage.this.repositoryViewer.refresh();
                SelectRepositoryPage.this.checkIfRepositoryStillInView(activeRepositoryNode);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        showAllProjectsButton.setSelection(true);
        showAllProjectsButton.notifyListeners(13, null);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Group repositoryGroup = new Group(container, 0);
        repositoryGroup.setText("Repositories");
        repositoryGroup.setBackgroundMode(1);
        this.createFilterText(repositoryGroup);
        this.createButtonShowAllProjects(repositoryGroup);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)repositoryGroup);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)repositoryGroup);
        this.repositoryViewer = CheckboxTableViewer.newCheckList((Composite)repositoryGroup, (int)2820);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider());
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        this.repositoryViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.repositoryViewer.addFilter((ViewerFilter)this.searchFilter);
        this.checkRepositoryStateListener = new CheckRepositoryStateListener();
        this.repositoryViewer.addCheckStateListener(this.checkRepositoryStateListener);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 40).applyTo(this.repositoryViewer.getControl());
        if (this.repositoryViewer.getTable().getItems().length == 1) {
            this.checkRepositoryStateListener.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.repositoryViewer, this.repositoryViewer.getElementAt(0), true));
        }
        this.setPageComplete(true);
        this.setControl((Control)container);
    }

    private void setNoRepositorySelected() {
        this.setMessage("If no local repository is selected, then only the task will be active but no repository action will be performed!", 1);
        this.settings.setRepository(null);
        this.setPageComplete(true);
    }

    public boolean canFlipToNextPage() {
        if (this.settings.getRepository() != null) {
            return super.canFlipToNextPage();
        }
        return false;
    }

    public class CheckRepositoryStateListener
    implements ICheckStateListener {
        boolean clean;

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.clean = true;
            if (event.getChecked()) {
                Repository rep = ((RepositoryNode)event.getElement()).getRepository();
                SelectRepositoryPage.this.settings.setRepository(rep);
                SelectRepositoryPage.this.settings.setDbCommit(Activator.fetchDbCommit(rep));
                SelectRepositoryPage.this.settings.setArtifactsCommit(Activator.fetchArtifactsCommit(rep));
                SelectRepositoryPage.this.repositoryViewer.setAllChecked(false);
                SelectRepositoryPage.this.repositoryViewer.setChecked(event.getElement(), true);
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (final Git git = new Git(rep);){
                        SelectRepositoryPage.this.setMessage("Check repository status...", 1);
                        SelectRepositoryPage.this.getContainer().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                try {
                                    CheckRepositoryStateListener.this.clean = git.status().call().getUncommittedChanges().isEmpty();
                                }
                                catch (GitAPIException | NoWorkTreeException e) {
                                    SelectRepositoryPage.this.logger.error("Error while trying to get the state of the repository", e);
                                }
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (InvocationTargetException e) {
                    SelectRepositoryPage.this.logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    SelectRepositoryPage.this.logger.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (!this.clean) {
                    MessageDialog.openError((Shell)SelectRepositoryPage.this.getShell(), (String)"Dirty workspace", (String)"The workspace of this repository is dirty. You have to commit, stash, or undo your changes before you can create a new branch in this repository.");
                    SelectRepositoryPage.this.setPageComplete(false);
                } else {
                    SelectRepositoryPage.this.setPageComplete(rep != null);
                    SelectRepositoryPage.this.settings.deriveDefaults();
                    SelectRepositoryPage.this.setMessage("");
                }
            } else {
                SelectRepositoryPage.this.setNoRepositorySelected();
            }
        }
    }
}

