/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.external.DbAndBinaryJob;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import com.proalpha.pds.gitutils.mylyn.SelectActionPage;
import java.io.IOException;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBAndBinaryWizard
extends Wizard {
    private final Logger logger = LoggerFactory.getLogger(DBAndBinaryWizard.class);
    private final SelectActionPage actionsPage;
    private FeatureBranchSettings settings = new FeatureBranchSettings();
    private ReconcileActionSettings recoSettings = new ReconcileActionSettings();

    public DBAndBinaryWizard(Repository repository) {
        String branch = "";
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            this.logger.error("Couldn't get branch of repository!");
        }
        this.settings.setRepository(repository);
        this.settings.setDbCommit(Activator.fetchDbCommit(repository));
        this.settings.setArtifactsCommit(Activator.fetchArtifactsCommit(repository));
        this.settings.setSourceBranch(branch);
        this.settings.setTargetBranch(branch);
        this.settings.setUpdateSourceBranch(false);
        this.settings.setUpdateTargetBranch(false);
        this.actionsPage = new SelectActionPage(this.settings, this.recoSettings);
        super.setWindowTitle("proALPHA local reconcile");
    }

    public boolean performFinish() {
        this.reconcileAction();
        return true;
    }

    public void addPages() {
        super.addPage((IWizardPage)this.actionsPage);
    }

    private void reconcileAction() {
        if (this.settings.getRepository() != null && this.actionsPage.isPageComplete()) {
            DbAndBinaryJob job = new DbAndBinaryJob(this.settings.getRepository(), this.recoSettings);
            job.setUser(true);
            job.setRule(RuleUtil.getRule((Repository)this.settings.getRepository()));
            job.schedule();
        }
    }
}

