/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.git.PaGitConfig;
import com.proalpha.git.model.server.GitServerRepository;
import com.proalpha.git.util.PaBranchName;
import com.proalpha.git.util.PaRepository;
import com.proalpha.git.util.bitbucket.BitbucketRestCallGetRepoList;
import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.gitutils.cherrypick.CherryPickWizard;
import com.proalpha.pds.gitutils.cherrypick.PrefixMatchFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.Bundle;

public class CherryPickPage
extends WizardPage {
    private Repository srcRepository;
    private List<GitServerRepository> currRepos;
    private Map<String, Set<String>> projectRepositoryMap;
    private Button btnUpdateTargetBranchPoint;
    private ComboViewer cvSrcProject;
    private ComboViewer cvSrcRepository;
    private ComboViewer cvSrcBranch;
    private Text txtSrcFeature;
    private Text txtTargetBranchPoint;
    private Text txtTargetBranch;
    private Text txtTargetFeature;
    private Button btnFetchCommits;
    private Button btnEditBranchname;
    private Button btnOnlyShowMaster;
    ScrolledComposite scrolledComposite;
    private Label infoLabel;
    private CherryPickSettings cherryPickSettings;
    private static final String PAGE_NAME = "pAGitCherryPickPage";

    public CherryPickPage(Repository repository) {
        super(CherryPickPage.class.getName());
        this.srcRepository = repository;
        this.setTitle("proALPHA CherryPick");
        this.setMessage("Select repository and branch which needs to get picked into your current repository", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        this.cherryPickSettings = ((CherryPickWizard)this.getWizard()).getSettings();
        this.currRepos = this.getServerRepositories();
        this.projectRepositoryMap = this.fillProjectRepositoryMap();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createSourceControls(container);
        this.createTargetControls(container);
        this.setControl((Control)container);
        GridData gridData = new GridData(4, 0x1000000, false, false, 3, 1);
        Composite container_bottom = new Composite(container, 0);
        container_bottom.setLayoutData((Object)gridData);
        gridData.widthHint = 488;
        gridData.heightHint = 100;
        this.scrolledComposite = new ScrolledComposite(container_bottom, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBounds(0, 0, 408, 100);
        this.infoLabel = new Label((Composite)this.scrolledComposite, 0);
        this.infoLabel.setBounds(0, 0, 408, 100);
        this.infoLabel.setText("");
        this.btnFetchCommits = new Button(container_bottom, 0);
        this.btnFetchCommits.setBounds(443, 0, 120, 30);
        this.btnFetchCommits.setText("Fetch Commits");
        this.btnFetchCommits.setEnabled(false);
        this.addSrcWidgetListeners();
        this.addTargetWidgetListeners();
        this.addButtonWidgetListeners();
        this.checkRepoAndProposeBranches();
        ITaskActivityManager taskActivityManager = TasksUi.getTaskActivityManager();
        if (taskActivityManager != null && taskActivityManager.getActiveTask() != null && taskActivityManager.getActiveTask().getTaskKey() != null) {
            this.setTxtFeatureText(taskActivityManager.getActiveTask().getTaskKey());
            this.txtTargetFeature.setText(taskActivityManager.getActiveTask().getTaskKey());
        }
        this.setPageComplete(false);
    }

    private void createTargetControls(Composite container) {
        Group grpTarget = new Group(container, 0);
        GridData gdGrpTarget = new GridData(4, 0x1000000, false, false, 3, 1);
        gdGrpTarget.widthHint = 450;
        gdGrpTarget.heightHint = 110;
        grpTarget.setLayoutData((Object)gdGrpTarget);
        grpTarget.setText("Target");
        Label label1 = new Label((Composite)grpTarget, 0);
        label1.setText("Repository");
        label1.setBounds(10, 22, 80, 15);
        Text txtTargetRepository = new Text((Composite)grpTarget, 0);
        txtTargetRepository.setBounds(96, 23, 347, 21);
        txtTargetRepository.setText(this.srcRepository.getDirectory().toString());
        txtTargetRepository.setEnabled(false);
        Label lblBranchPoint = new Label((Composite)grpTarget, 0);
        lblBranchPoint.setText("Branch Point");
        lblBranchPoint.setBounds(10, 49, 80, 15);
        this.txtTargetBranchPoint = new Text((Composite)grpTarget, 2048);
        this.txtTargetBranchPoint.setBounds(96, 46, 212, 21);
        try {
            String remoteTrackingRef;
            List branches = PaRepository.getMasterBranches((Repository)this.srcRepository);
            String mainBranch = null;
            if (branches != null && !branches.isEmpty()) {
                mainBranch = (String)branches.get(0);
            } else {
                branches = PaRepository.getCodeFreezeBranches((Repository)this.srcRepository);
                if (branches != null && !branches.isEmpty()) {
                    mainBranch = (String)branches.get(0);
                }
            }
            if (mainBranch == null) {
                mainBranch = this.srcRepository.getFullBranch();
            }
            if ((remoteTrackingRef = PaRepository.getRemoteTrackingBranch((Repository)this.srcRepository, (String)mainBranch)) == null || remoteTrackingRef.isEmpty()) {
                remoteTrackingRef = "HEAD";
            }
            this.txtTargetBranchPoint.setText(remoteTrackingRef);
            this.cherryPickSettings.setTargetBranchPoint(remoteTrackingRef);
        }
        catch (IOException ex) {
            this.setMessage("Could not determine the branch name to be used as branching point!", 3);
        }
        this.btnUpdateTargetBranchPoint = new Button((Composite)grpTarget, 32);
        this.btnUpdateTargetBranchPoint.setBounds(314, 48, 129, 16);
        this.btnUpdateTargetBranchPoint.setText("update/fetch");
        this.btnUpdateTargetBranchPoint.setSelection(this.cherryPickSettings.isUpdateTargetBranchPoint());
        Label label2 = new Label((Composite)grpTarget, 0);
        label2.setText("Branch");
        label2.setBounds(10, 76, 80, 15);
        this.txtTargetBranch = new Text((Composite)grpTarget, 2048);
        this.txtTargetBranch.setBounds(96, 73, 212, 21);
        this.txtTargetBranch.setEnabled(false);
        this.btnEditBranchname = new Button((Composite)grpTarget, 32);
        this.btnEditBranchname.setBounds(314, 75, 129, 16);
        this.btnEditBranchname.setText("modify branch name");
        Label label3 = new Label((Composite)grpTarget, 0);
        label3.setText("Feature");
        label3.setBounds(10, 103, 80, 15);
        this.txtTargetFeature = new Text((Composite)grpTarget, 2048);
        this.txtTargetFeature.setBounds(96, 101, 162, 21);
    }

    private void createSourceControls(Composite container) {
        String gitDefaultRepo = Activator.getDefault().getPreferenceStore().getString("PaGitDefaultRepo");
        String gitDefaultProject = "";
        String gitShortDefaultRepo = "";
        if (gitDefaultRepo.contains("/")) {
            String[] splitGitDefaultRepo = gitDefaultRepo.split("/");
            gitDefaultProject = splitGitDefaultRepo[0];
            gitShortDefaultRepo = splitGitDefaultRepo[1];
        }
        Group grpSource = new Group(container, 0);
        GridData gdGrpSource = new GridData(4, 128, true, false, 2, 1);
        gdGrpSource.heightHint = 111;
        gdGrpSource.widthHint = 450;
        grpSource.setLayoutData((Object)gdGrpSource);
        grpSource.setText("Source");
        Label lblProject = new Label((Composite)grpSource, 0);
        lblProject.setText("Project");
        lblProject.setBounds(10, 22, 80, 15);
        Label lblRepository = new Label((Composite)grpSource, 0);
        lblRepository.setText("Repository");
        lblRepository.setBounds(10, 49, 80, 15);
        Label lblBranch = new Label((Composite)grpSource, 0);
        lblBranch.setText("Branch");
        lblBranch.setBounds(10, 76, 80, 15);
        Label lblFeature = new Label((Composite)grpSource, 0);
        lblFeature.setText("Feature");
        lblFeature.setBounds(10, 103, 80, 15);
        PrefixMatchFilter projectFilter = new PrefixMatchFilter();
        this.cvSrcProject = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcProject.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcProject.getCombo().setBounds(96, 19, 212, 21);
        this.cvSrcProject.addFilter((ViewerFilter)projectFilter);
        Set<String> projectsSet = this.projectRepositoryMap.keySet();
        Object[] projects = new String[projectsSet.size()];
        projectsSet.toArray(projects);
        Arrays.sort(projects);
        this.cvSrcProject.setInput((Object)projects);
        this.cvSrcProject.setSelection((ISelection)new StructuredSelection((Object)gitDefaultProject));
        PrefixMatchFilter repositoryFilter = new PrefixMatchFilter();
        this.cvSrcRepository = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcRepository.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcRepository.getCombo().setBounds(96, 46, 212, 21);
        this.cvSrcRepository.addFilter((ViewerFilter)repositoryFilter);
        Set<String> repositorySet = this.projectRepositoryMap.get(gitDefaultProject);
        if (repositorySet == null) {
            repositorySet = new HashSet<String>();
        }
        Object[] repositories = new String[repositorySet.size()];
        repositorySet.toArray(repositories);
        Arrays.sort(repositories);
        this.cvSrcRepository.setInput((Object)repositories);
        this.cvSrcRepository.setSelection((ISelection)new StructuredSelection((Object)gitShortDefaultRepo));
        PrefixMatchFilter branchFilter = new PrefixMatchFilter();
        this.cvSrcBranch = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcBranch.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcBranch.getCombo().setBounds(96, 73, 212, 21);
        this.cvSrcBranch.addFilter((ViewerFilter)branchFilter);
        this.cvSrcBranch.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CherryPickPage.this.cvSrcBranch.getSelection() != event.getSelection()) {
                    CherryPickPage.this.setPageComplete(false);
                }
            }
        });
        this.txtSrcFeature = new Text((Composite)grpSource, 2048);
        this.txtSrcFeature.setBounds(96, 100, 162, 21);
        Button btnRefreshRepos = new Button((Composite)grpSource, 0);
        btnRefreshRepos.setToolTipText("Reload repositories from server");
        btnRefreshRepos.setImage(ResourceManager.getPluginImage("com.proalpha.pds.gitutils", "icons/refresh.gif"));
        btnRefreshRepos.setBounds(314, 18, 28, 23);
        IDialogSettings settings = this.getDialogSettings();
        this.btnOnlyShowMaster = new Button((Composite)grpSource, 32);
        this.btnOnlyShowMaster.setBounds(314, 75, 129, 16);
        this.btnOnlyShowMaster.setText("only show master");
        this.btnOnlyShowMaster.setSelection(settings.getBoolean("ONLY_SHOW_MASTER"));
    }

    private void addSrcWidgetListeners() {
        this.cvSrcProject.getCombo().addModifyListener(modifyEvent -> this.proposeRepositories());
        this.cvSrcRepository.getCombo().addModifyListener(modifyEvent -> this.checkRepoAndProposeBranches());
        this.cvSrcRepository.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source repository");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.cvSrcBranch.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose your source branch");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (CherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0 && CherryPickPage.this.checkBranch() && (featureByBranch = CherryPickPage.this.getFeatureText(CherryPickPage.this.cvSrcBranch.getCombo().getText())) != null) {
                    CherryPickPage.this.setTxtFeatureText(featureByBranch);
                }
            }
        });
        this.txtSrcFeature.addModifyListener(modifyEvent -> {
            if (this.cvSrcBranch.getCombo().getText().length() != 0) {
                this.checkBranch();
                this.txtTargetFeature.setText(this.txtSrcFeature.getText());
            }
        });
        this.txtSrcFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your feature to pick");
            }

            public void focusLost(FocusEvent e) {
                if (CherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0 && CherryPickPage.this.txtSrcFeature.getText().length() != 0) {
                    CherryPickPage.this.btnFetchCommits.setEnabled(true);
                }
                String feature = CherryPickPage.this.txtSrcFeature.getText();
                CherryPickPage.this.check_caused_issues(feature);
            }
        });
        KeyListener projectKeyListener = this.createKeyListener(this.cvSrcProject);
        this.cvSrcProject.getCombo().addKeyListener(projectKeyListener);
        KeyListener repositoryKeyListener = this.createKeyListener(this.cvSrcRepository);
        this.cvSrcRepository.getCombo().addKeyListener(repositoryKeyListener);
        KeyListener branchKeyListener = this.createKeyListener(this.cvSrcBranch);
        this.cvSrcBranch.getCombo().addKeyListener(branchKeyListener);
        this.cvSrcBranch.getCombo().addModifyListener(modifyListener -> {
            String featureByBranch;
            if (this.cvSrcBranch.getCombo().getText().length() != 0 && this.checkBranch() && (featureByBranch = this.getFeatureText(this.cvSrcBranch.getCombo().getText())) != null) {
                this.setTxtFeatureText(featureByBranch);
            }
        });
    }

    private void check_caused_issues(String issue) {
        LinkedList<String> command = new LinkedList<String>();
        command.add("python");
        command.add("-m");
        command.add("pa_common.pds_functions.jira_issue_links");
        command.add("-i");
        command.add(issue);
        command.add("-l");
        command.add("INFO");
        this.infoLabel.setText("");
        this.run_command(command);
    }

    private boolean run_command(List<String> command) {
        boolean result = false;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        try {
            String line;
            Process p = builder.start();
            InputStream inputStream = p.getErrorStream();
            BufferedReader bufRead = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufRead.readLine()) != null) {
                String text = this.infoLabel.getText();
                this.infoLabel.setText(String.valueOf(text) + "\n" + line);
                this.getShell().getDisplay().update();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setTxtFeatureText(String text) {
        this.txtSrcFeature.setText(text);
        this.txtSrcFeature.setFocus();
        this.getShell().setFocus();
    }

    private KeyListener createKeyListener(final ComboViewer viewer) {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String currentInput = viewer.getCombo().getText();
                String inputFilter = ((PrefixMatchFilter)viewer.getFilters()[0]).getInput();
                if (currentInput.length() < inputFilter.length() || Character.isDigit(e.character) || Character.isAlphabetic(e.character)) {
                    if (e.keyCode == 27) {
                        ((PrefixMatchFilter)viewer.getFilters()[0]).setInput("");
                        currentInput = "";
                    } else {
                        ((PrefixMatchFilter)viewer.getFilters()[0]).setInput(currentInput);
                    }
                    viewer.refresh(true);
                    viewer.getCombo().setListVisible(e.keyCode != 27);
                    viewer.getCombo().setText(currentInput);
                    viewer.getCombo().setSelection(new Point(currentInput.length(), currentInput.length()));
                }
            }
        };
    }

    private void addTargetWidgetListeners() {
        this.txtTargetBranchPoint.addModifyListener(modifyEvent -> {
            if (this.txtTargetBranchPoint.getText().length() != 0) {
                this.cherryPickSettings.setTargetBranchPoint(this.txtTargetBranchPoint.getText());
            }
        });
        this.txtTargetBranchPoint.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your new branch point");
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.txtTargetBranch.addModifyListener(modifyEvent -> {
            if (this.txtTargetBranch.getText().length() != 0) {
                this.cherryPickSettings.setTargetBranch(this.txtTargetBranch.getText());
            }
        });
        this.txtTargetBranch.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Type your new branchname");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (CherryPickPage.this.txtTargetBranch.getText().length() != 0 && (featureByBranch = CherryPickPage.this.getFeatureText(CherryPickPage.this.txtTargetBranch.getText())) != null) {
                    CherryPickPage.this.txtTargetFeature.setText(featureByBranch);
                }
            }
        });
        this.txtTargetFeature.addModifyListener(modifyEvent -> {
            if (this.txtTargetFeature.getText().length() != 0) {
                this.cherryPickSettings.setTargetIssue(this.txtTargetFeature.getText());
            }
        });
        this.txtTargetFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CherryPickPage.this.setMessage("Choose a target feature which is used for first line of commit message");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (CherryPickPage.this.txtTargetFeature.getText().length() == 0 && (featureByBranch = CherryPickPage.this.getFeatureText(CherryPickPage.this.txtTargetBranch.getText())) != null) {
                    CherryPickPage.this.txtTargetFeature.setText(featureByBranch);
                }
                CherryPickPage.this.cherryPickSettings.setTargetIssue(CherryPickPage.this.txtTargetFeature.getText());
            }
        });
        this.btnUpdateTargetBranchPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.cherryPickSettings.setUpdateTargetBranchPoint(CherryPickPage.this.btnUpdateTargetBranchPoint.getSelection());
            }
        });
    }

    private void addButtonWidgetListeners() {
        this.btnEditBranchname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.txtTargetBranch.setEnabled(CherryPickPage.this.btnEditBranchname.getSelection());
                if (!CherryPickPage.this.btnEditBranchname.getSelection()) {
                    CherryPickPage.this.checkBranch();
                }
            }
        });
        this.btnFetchCommits.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CherryPickPage.this.fetchCommits();
            }
        });
        this.btnOnlyShowMaster.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDialogSettings settings = CherryPickPage.this.getDialogSettings();
                settings.put("ONLY_SHOW_MASTER", CherryPickPage.this.btnOnlyShowMaster.getSelection());
                CherryPickPage.this.checkRepoAndProposeBranches();
            }
        });
    }

    protected void fetchCommits() {
        this.cherryPickSettings.setSourceIssue(this.txtSrcFeature.getText());
        this.cherryPickSettings.setSourceBranch(this.cvSrcBranch.getCombo().getText());
        this.cherryPickSettings.setTargetIssue(this.txtTargetFeature.getText());
        String projectname = this.cvSrcProject.getCombo().getText();
        String repoName = this.cvSrcRepository.getCombo().getText();
        for (GitServerRepository actRepo : this.currRepos) {
            if (!actRepo.getProject().equals(projectname) || !actRepo.getName().equals(repoName)) continue;
            this.cherryPickSettings.setSourceRepoString(projectname, repoName);
            break;
        }
        Boolean commitsfound = ((CherryPickWizard)this.getWizard()).gatherCommits();
        if (!commitsfound.booleanValue()) {
            this.setMessage("No commits found!", 2);
        } else {
            this.setMessage("Commits found! Push 'Next' to view or 'Finish' to pick them", 1);
        }
        this.setPageComplete(commitsfound);
    }

    private List<GitServerRepository> getServerRepositories() {
        BitbucketRestCallGetRepoList restcall = new BitbucketRestCallGetRepoList();
        restcall.setSubUrl("repos");
        restcall.execute();
        ArrayList serverRepositories = (ArrayList)restcall.getRestResponse();
        return serverRepositories;
    }

    private String getFeatureText(String branchText) {
        Pattern p = Pattern.compile("(.*\\.)?(" + PaGitConfig.getStringFromConfig((String)"issue_key_format") + ")$");
        Matcher m = p.matcher(branchText);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    private boolean checkBranch() {
        boolean foundIt = false;
        String srcBranchName = this.cvSrcBranch.getCombo().getText();
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (srcBranchName.length() == 0) {
            this.setPageComplete(false);
            return false;
        }
        String projectname = this.cvSrcProject.getCombo().getText();
        String repoName = this.cvSrcRepository.getCombo().getText();
        for (GitServerRepository repository : this.currRepos) {
            if (repository.getProject().equals(projectname) && repository.getName().equals(repoName)) {
                for (String actBranch : repository.getBranches()) {
                    if (!actBranch.equals(srcBranchName)) continue;
                    foundIt = true;
                }
            }
            if (foundIt) break;
        }
        if (!foundIt) {
            this.setMessage("Branch not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            return false;
        }
        this.cherryPickSettings.setSourceBranch(srcBranchName);
        this.proposeTargetBranchName(srcBranchName);
        this.btnFetchCommits.setEnabled(true);
        return true;
    }

    private void proposeTargetBranchName(String srcBranchName) {
        String targetBranch = srcBranchName;
        try {
            String versionPrefix = PaBranchName.getVersion((String)this.srcRepository.getBranch());
            versionPrefix = versionPrefix != null ? String.valueOf(versionPrefix) + "." : "";
            targetBranch = this.txtSrcFeature.getText() != null && !this.txtSrcFeature.getText().isEmpty() ? String.valueOf(versionPrefix) + this.txtSrcFeature.getText() : versionPrefix;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.txtTargetBranch.setText(targetBranch);
        this.cherryPickSettings.setTargetBranch(targetBranch);
    }

    protected void checkRepoAndProposeBranches() {
        boolean foundIt = false;
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (this.cvSrcRepository.getCombo().getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        String projectname = this.cvSrcProject.getCombo().getText();
        String repoName = this.cvSrcRepository.getCombo().getText();
        for (GitServerRepository repository : this.currRepos) {
            if (!repository.getProject().equals(projectname) || !repository.getName().equals(repoName)) continue;
            List allBranches = repository.getBranches();
            Collections.sort(allBranches);
            String[] branches = (String[])allBranches.stream().toArray(String[]::new);
            if (this.btnOnlyShowMaster.getSelection()) {
                branches = this.filterMasterBranches(branches);
            }
            this.cvSrcBranch.setInput((Object)branches);
            foundIt = true;
            break;
        }
        if (!foundIt) {
            this.setMessage("Repository not found!", 2);
            this.setPageComplete(false);
            this.btnFetchCommits.setEnabled(false);
            this.cvSrcBranch.setInput((Object)new String[0]);
            return;
        }
        this.cherryPickSettings.setSourceRepoString(projectname, repoName);
    }

    protected void proposeRepositories() {
        String projectname = this.cvSrcProject.getCombo().getText();
        if (!this.projectRepositoryMap.containsKey(projectname)) {
            this.setMessage("Project not found!", 2);
            this.setPageComplete(false);
            this.cvSrcRepository.setInput((Object)new String[0]);
            return;
        }
        Set<String> repoSet = this.projectRepositoryMap.get(projectname);
        Object[] repos = new String[repoSet.size()];
        repoSet.toArray(repos);
        Arrays.sort(repos);
        this.cvSrcRepository.setInput((Object)repos);
    }

    private Map<String, Set<String>> fillProjectRepositoryMap() {
        this.projectRepositoryMap = new HashMap<String, Set<String>>();
        for (GitServerRepository repository : this.currRepos) {
            Set<String> repositoriesForProject = this.projectRepositoryMap.get(repository.getProject());
            if (repositoriesForProject != null) {
                repositoriesForProject.add(repository.getName());
                continue;
            }
            String projectName = repository.getProject();
            String repositoryName = repository.getName();
            HashSet<String> repositories = new HashSet<String>();
            repositories.add(repositoryName);
            this.projectRepositoryMap.put(projectName, repositories);
        }
        return this.projectRepositoryMap;
    }

    private String[] filterMasterBranches(String[] branches) {
        ArrayList<String> masterBranches = new ArrayList<String>();
        String[] stringArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            String branch = stringArray[n2];
            if (branch.contains("master")) {
                masterBranches.add(branch);
            }
            ++n2;
        }
        String[] masterArray = new String[masterBranches.size()];
        masterBranches.toArray(masterArray);
        return masterArray;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
        if (section == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        return section;
    }
}

