/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.FeatureBranchJob;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchOperation;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchSettings;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import com.proalpha.pds.gitutils.mylyn.SelectActionPage;
import com.proalpha.pds.gitutils.mylyn.SelectBranchesPage;
import com.proalpha.pds.gitutils.mylyn.SelectRepositoryPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class FeatureBranchWizard
extends Wizard {
    private final SelectRepositoryPage repPage;
    private final SelectActionPage actionsPage;
    private final SelectBranchesPage branchesPage;
    private FeatureBranchSettings settings = new FeatureBranchSettings();
    private ReconcileActionSettings recoSettings = new ReconcileActionSettings();

    public FeatureBranchWizard(ITask task) {
        this.settings.setTask(task);
        this.repPage = new SelectRepositoryPage(this.settings);
        this.actionsPage = new SelectActionPage(this.settings, this.recoSettings);
        this.branchesPage = new SelectBranchesPage(this.settings);
        try {
            TaskData taskData = TasksUiPlugin.getTaskDataManager().getTaskData(task);
            for (TaskAttribute attribute : taskData.getRoot().getAttributes().values()) {
                if (attribute.getId().equals("attribute.jira.issue_epic_key")) {
                    this.settings.setTaskEpic(attribute.getValue());
                    continue;
                }
                if (attribute.getId().equals("attribute.jira.issue_parent_key")) {
                    this.settings.setTaskParent(attribute.getValue());
                    continue;
                }
                if (!attribute.getId().equals("attribute.jira.issue_sprint_key")) continue;
                this.settings.setTaskSprint(attribute.getValue().replace(" ", "_"));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.setWindowTitle("proALPHA Feature Branch Generator");
    }

    public boolean performFinish() {
        this.featureBranchAction();
        return true;
    }

    public void addPages() {
        super.addPage((IWizardPage)this.repPage);
        super.addPage((IWizardPage)this.branchesPage);
        super.addPage((IWizardPage)this.actionsPage);
    }

    public void dispose() {
        super.dispose();
    }

    public FeatureBranchSettings getSettings() {
        return this.settings;
    }

    public void setSettings(FeatureBranchSettings settings) {
        this.settings = settings;
    }

    private void featureBranchAction() {
        if (this.settings.getRepository() != null && (this.repPage.canFlipToNextPage() || this.branchesPage.isPageComplete())) {
            FeatureBranchOperation op = new FeatureBranchOperation(this.settings, this.recoSettings);
            FeatureBranchJob job = new FeatureBranchJob(op);
            job.setUser(true);
            job.setRule(RuleUtil.getRule((Repository)this.settings.getRepository()));
            job.schedule();
        }
    }
}

