/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.export_changed_files;

import com.proalpha.git.util.PaRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ExportFilesPage
extends WizardPage {
    private Button staging;
    private Combo branches;
    private Label destinationLabel;
    private Button browseDirectory;
    private Text destinationDirectory;
    private Repository repository;
    private static final Bundle BUNDLE = FrameworkUtil.getBundle(ExportFilesPage.class);
    private static final ILog LOGGER = Platform.getLog((Bundle)BUNDLE);

    public ExportFilesPage(Repository repository) {
        super(ExportFilesPage.class.getName());
        this.repository = repository;
        this.setTitle("proALPHA Extract Changed Files");
        this.setMessage("Select Branch or tick Staging to define which files to extract", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.staging = new Button(container, 32);
        this.staging.setText("Use Files in Staging");
        GridData stagingData = new GridData(8);
        stagingData.widthHint = 250;
        stagingData.heightHint = 15;
        stagingData.horizontalSpan = 2;
        stagingData.verticalIndent = 35;
        this.staging.setLayoutData((Object)stagingData);
        this.branches = new Combo(container, 8);
        GridData branchesData = new GridData(8);
        branchesData.widthHint = 178;
        branchesData.heightHint = 15;
        branchesData.horizontalSpan = 2;
        branchesData.verticalIndent = 10;
        this.branches.setLayoutData((Object)branchesData);
        this.branches.setItems(this.getBranches());
        this.destinationLabel = new Label(container, 0);
        this.destinationLabel.setText("Destination directory for changed files:");
        GridData destinationData = new GridData(8);
        destinationData.widthHint = 250;
        destinationData.heightHint = 15;
        destinationData.horizontalSpan = 2;
        destinationData.verticalIndent = 25;
        this.destinationLabel.setLayoutData((Object)destinationData);
        this.browseDirectory = new Button(container, 8);
        this.browseDirectory.setText("Browse");
        GridData browseData = new GridData(2);
        browseData.widthHint = 50;
        browseData.heightHint = 22;
        browseData.horizontalSpan = 1;
        this.browseDirectory.setLayoutData((Object)browseData);
        this.destinationDirectory = new Text(container, 2052);
        GridData destData = new GridData(2);
        destData.widthHint = 270;
        destData.heightHint = 15;
        destData.horizontalSpan = 1;
        this.destinationDirectory.setLayoutData((Object)destData);
        this.setActions();
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    private void setActions() {
        this.browseDirectory.addListener(13, (Listener)new BrowseListener());
        this.staging.addSelectionListener((SelectionListener)new StagingListener());
    }

    private String[] getBranches() {
        List branches = PaRepository.getLocalBranches((Repository)this.repository);
        String[] branchArray = new String[branches.size()];
        int index = 0;
        Iterator iterator = branches.iterator();
        while (iterator.hasNext()) {
            String branch;
            branchArray[index] = branch = (String)iterator.next();
            ++index;
        }
        return branchArray;
    }

    private List<String> createPythonCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add("python");
        command.add("-m");
        command.add("pa_common.pds_functions.export_changed_files");
        String repoPath = this.repository.getDirectory().toString().replace(".git", "");
        command.add("--repository_path");
        command.add(repoPath);
        String destDir = this.destinationDirectory.getText();
        command.add("--destination_dir");
        command.add(destDir);
        if (!this.staging.getSelection()) {
            command.add("--branch");
            command.add(this.branches.getText());
        }
        return command;
    }

    private void logInfo(String message) {
        this.log(message, 1);
    }

    private void logError(String message) {
        this.log(message, 4);
    }

    private void log(String message, int severity) {
        LOGGER.log((IStatus)new Status(severity, BUNDLE.getSymbolicName(), message));
    }

    public String runPythonExtractFiles() {
        List<String> command = this.createPythonCommand();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        String error = "";
        String destDir = "";
        int succeeded = -1;
        try {
            String line;
            Process p = builder.start();
            InputStream inputStream = p.getErrorStream();
            BufferedReader bufRead = new BufferedReader(new InputStreamReader(inputStream));
            this.logInfo("Running Command: " + this.commandToString(command));
            while ((line = bufRead.readLine()) != null) {
                if (line.contains("[ERROR]")) {
                    error = line.split("  - ")[1];
                    this.logError(line);
                    continue;
                }
                if (line.contains("DEST_DIR:")) {
                    destDir = line.split("DEST_DIR:")[1];
                    continue;
                }
                this.logInfo(line);
            }
            succeeded = p.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (error.equals("")) {
            if (succeeded != 0) {
                error = "Python unexpectedly failed.\nPlease view Error Log for more information";
            } else if (!destDir.equals("")) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Files exported", (String)("Files were copied to " + destDir));
            }
        }
        return error;
    }

    private String commandToString(List<String> command) {
        String outputCommand = "";
        for (String commandArgument : command) {
            outputCommand = String.valueOf(outputCommand) + " " + commandArgument;
        }
        return outputCommand;
    }

    public boolean preconditionsMet() {
        if (!this.staging.getSelection() && this.branches.getText().equals("")) {
            return false;
        }
        return !this.destinationDirectory.getText().equals("");
    }

    private class BrowseListener
    implements Listener {
        private BrowseListener() {
        }

        public void handleEvent(Event arg0) {
            DirectoryDialog dlg = new DirectoryDialog(ExportFilesPage.this.getShell());
            String selectedDir = dlg.open();
            ExportFilesPage.this.destinationDirectory.setText(selectedDir);
        }
    }

    private class StagingListener
    extends SelectionAdapter {
        private StagingListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (ExportFilesPage.this.staging.getSelection()) {
                ExportFilesPage.this.branches.deselectAll();
                ExportFilesPage.this.branches.setEnabled(false);
            } else {
                ExportFilesPage.this.branches.setEnabled(true);
            }
        }
    }
}

