/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.search;

import com.proalpha.pds.gitutils.search.GitGrepContentProvider;
import com.proalpha.pds.gitutils.search.GitGrepLabelProvider;
import com.proalpha.pds.gitutils.search.GitGrepSearchResult;
import com.proalpha.pds.gitutils.search.GitGrepSearchResultElement;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitGrepSearchResultPage
extends Page
implements ISearchResultPage {
    private final Logger logger = LoggerFactory.getLogger(GitGrepSearchResultPage.class);
    private Control fBusyLabel;
    private GitGrepSearchResult fInput;
    private IQueryListener fQueryListener;
    private ISearchResultListener fListener;
    private ISearchResultViewPart fViewPart;
    private PageBook fPagebook;
    private SashForm sashForm;
    private Set<Object> fBatchedUpdates = new HashSet<Object>();
    private String fId;
    private StyledText textArea;
    private TableViewer fViewer;
    private boolean fBatchedClearAll = false;
    private boolean fIsBusyShown;
    private volatile boolean fIsUIUpdateScheduled = false;
    private volatile boolean fScheduleEnsureSelection = false;

    public GitGrepSearchResultPage() {
        this.fListener = new ISearchResultListener(){

            public void searchResultChanged(SearchResultEvent e) {
                GitGrepSearchResultPage.this.handleSearchResultChanged(e);
            }
        };
    }

    public void setID(String id) {
        this.fId = id;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        GitGrepSearchResult result = this.fInput;
        if (result == null) {
            return "";
        }
        return result.getLabel();
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.customizeTable(viewer);
        viewer.setContentProvider((IContentProvider)new GitGrepContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new GitGrepLabelProvider());
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                GitGrepSearchResultElement el1 = (GitGrepSearchResultElement)e1;
                GitGrepSearchResultElement el2 = (GitGrepSearchResultElement)e2;
                return el1.compareTo(el2);
            }

            public void sort(Viewer viewer, Object[] elements) {
                super.sort(viewer, elements);
            }
        });
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.fQueryListener = this.createQueryListener();
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.fBusyLabel = this.createBusyControl();
        this.sashForm = new SashForm((Composite)this.fPagebook, 256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setLayout((Layout)gridLayout);
        this.createViewer((Composite)this.sashForm);
        this.createTextArea((Composite)this.sashForm);
        this.showBusyLabel(this.fIsBusyShown);
        NewSearchUI.addQueryListener((IQueryListener)this.fQueryListener);
    }

    private void scheduleUIUpdate() {
        if (!this.fIsUIUpdateScheduled) {
            this.fIsUIUpdateScheduled = true;
            new UpdateUIJob().schedule();
        }
    }

    private IQueryListener createQueryListener() {
        return new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryRemoved(ISearchQuery query) {
            }

            public void queryStarting(final ISearchQuery query) {
                Runnable runnable1 = new Runnable(){

                    @Override
                    public void run() {
                        GitGrepSearchResultPage.this.updateBusyLabel();
                        GitGrepSearchResult result = GitGrepSearchResultPage.this.fInput;
                        if (result == null || !result.getQuery().equals(query)) {
                            return;
                        }
                        GitGrepSearchResultPage.this.scheduleUIUpdate();
                    }
                };
                GitGrepSearchResultPage.this.asyncExec(runnable1);
            }

            public void queryFinished(ISearchQuery query) {
                GitGrepSearchResultPage.this.postEnsureSelection();
            }
        };
    }

    protected void postEnsureSelection() {
        this.fScheduleEnsureSelection = true;
        this.scheduleUIUpdate();
    }

    private void createViewer(Composite parent) {
        TableViewer viewer;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.fViewer = viewer = new TableViewer(parent, 66306);
        this.fViewer.getTable().setLayoutData((Object)gridData);
        this.configureTableViewer(viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GitGrepSearchResultElement selectedElement = this.getSelectedElement();
                this.fillTextArea(selectedElement);
            }

            private void fillTextArea(GitGrepSearchResultElement selectedElement) {
                if (selectedElement.getBlock() == null || selectedElement.getLineNr() == null) {
                    return;
                }
                File fileToOpen = new File(selectedElement.getAbsolutePath());
                if (fileToOpen.exists() && fileToOpen.isFile()) {
                    byte[] fileContent = null;
                    try {
                        fileContent = Files.readAllBytes(fileToOpen.toPath());
                    }
                    catch (IOException e) {
                        GitGrepSearchResultPage.this.logger.debug("file content could not be read because ", (Throwable)e);
                    }
                    GitGrepSearchResultPage.this.textArea.setText(new String(fileContent));
                    GitGrepSearchResultPage.this.textArea.setTopIndex(Integer.parseInt(selectedElement.getLineNr()) - 1);
                    GitGrepSearchResultPage.this.textArea.setEditable(false);
                } else {
                    GitGrepSearchResultPage.this.logger.error("The file {} doesn't exist.", (Object)fileToOpen);
                }
            }

            private GitGrepSearchResultElement getSelectedElement() {
                IStructuredSelection selection = (IStructuredSelection)GitGrepSearchResultPage.this.fViewer.getSelection();
                GitGrepSearchResultElement selectedElement = selection.isEmpty() ? new GitGrepSearchResultElement() : (GitGrepSearchResultElement)selection.getFirstElement();
                return selectedElement;
            }
        });
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                block6: {
                    GitGrepSearchResultPage.this.fViewer = (TableViewer)event.getSource();
                    IStructuredSelection el = (IStructuredSelection)GitGrepSearchResultPage.this.fViewer.getSelection();
                    GitGrepSearchResultElement elem = (GitGrepSearchResultElement)el.getFirstElement();
                    File fileToOpen = new File(elem.getAbsolutePath());
                    if (fileToOpen.exists() && fileToOpen.isFile()) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                            if (!(editor instanceof ITextEditor)) break block6;
                            IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                            IDocument document = provider.getDocument((Object)editor.getEditorInput());
                            int start = 0;
                            try {
                                start = document.getLineOffset(Integer.parseInt(elem.getLineNr()) - 1);
                            }
                            catch (NumberFormatException | BadLocationException e) {
                                GitGrepSearchResultPage.this.logger.debug("line number could not be parsed to int because ", e);
                            }
                            ((ITextEditor)editor).selectAndReveal(start, 0);
                        }
                        catch (PartInitException e) {
                            GitGrepSearchResultPage.this.logger.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        GitGrepSearchResultPage.this.logger.error("The file {} doesn't exist.", (Object)fileToOpen);
                    }
                }
            }
        });
        this.fViewPart.updateLabel();
    }

    private void createTextArea(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.textArea = new StyledText(parent, 66306);
        this.textArea.setLayoutData((Object)gridData);
        FontData defaultFont = new FontData("Consolas", 10, 0);
        Font font = new Font((Device)parent.getDisplay(), defaultFont);
        this.textArea.setFont(font);
    }

    private void customizeTable(TableViewer viewer) {
        TableViewerColumn columnObject = new TableViewerColumn(viewer, 0);
        TableViewerColumn columnContent = new TableViewerColumn(viewer, 0);
        TableViewerColumn columnLine = new TableViewerColumn(viewer, 0);
        columnObject.getColumn().setText("Objectname");
        columnObject.getColumn().setResizable(true);
        columnObject.getColumn().setWidth(110);
        columnContent.getColumn().setText("Line");
        columnContent.getColumn().setResizable(true);
        columnContent.getColumn().setWidth(50);
        columnLine.getColumn().setText("Content");
        columnLine.getColumn().setResizable(true);
        columnLine.getColumn().setWidth(700);
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        FontData defaultFont = new FontData("Consolas", 10, 0);
        Font font = new Font((Device)viewer.getTable().getDisplay(), defaultFont);
        viewer.getTable().setFont(font);
    }

    private Control createBusyControl() {
        Table busyLabel = new Table((Composite)this.fPagebook, 0);
        TableItem item = new TableItem(busyLabel, 0);
        item.setText("searching....");
        busyLabel.setLayoutData((Object)new GridData(768));
        return busyLabel;
    }

    private void updateBusyLabel() {
        boolean shouldShowBusy;
        GitGrepSearchResult result = this.fInput;
        boolean bl = shouldShowBusy = result != null && NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery()) && result.getMatchCount() == 0;
        if (shouldShowBusy == this.fIsBusyShown) {
            return;
        }
        this.fIsBusyShown = shouldShowBusy;
        this.showBusyLabel(this.fIsBusyShown);
    }

    private void showBusyLabel(boolean shouldShowBusy) {
        if (shouldShowBusy) {
            this.fPagebook.showPage(this.fBusyLabel);
        } else {
            this.fPagebook.showPage((Control)this.sashForm);
        }
    }

    private void disposeViewer() {
        this.fViewer.getControl().dispose();
        this.fViewer = null;
    }

    public void dispose() {
        super.dispose();
        this.disposeViewer();
        NewSearchUI.removeQueryListener((IQueryListener)this.fQueryListener);
    }

    public void setFocus() {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public Control getControl() {
        return this.fPagebook;
    }

    public void setInput(ISearchResult newSearch, Object viewState) {
        if (newSearch instanceof GitGrepSearchResult) {
            this.textArea.setText("");
            GitGrepSearchResult oldSearch = this.fInput;
            if (oldSearch != null) {
                this.fViewer.setInput(null);
                oldSearch.removeListener(this.fListener);
            }
            this.fInput = (GitGrepSearchResult)newSearch;
            this.fInput.addListener(this.fListener);
            this.fViewer.setInput((Object)this.fInput);
            if (viewState instanceof ISelection) {
                this.fViewer.setSelection((ISelection)viewState, true);
            }
            this.updateBusyLabel();
            this.scheduleUIUpdate();
        }
    }

    public Object getUIState() {
        return this.fViewer.getSelection();
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    protected ISearchResultViewPart getViewPart() {
        return this.fViewPart;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    protected void handleSearchResultChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            this.postUpdate(((MatchEvent)e).getMatches());
        } else if (e instanceof RemoveAllEvent) {
            this.postClear();
        } else if (e instanceof FilterUpdateEvent) {
            this.postUpdate(((FilterUpdateEvent)e).getUpdatedMatches());
        }
    }

    private synchronized void postUpdate(Match[] matches) {
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            this.fBatchedUpdates.add(match.getElement());
            ++n2;
        }
        this.scheduleUIUpdate();
    }

    private void postClear() {
        this.fBatchedClearAll = true;
        this.fBatchedUpdates.clear();
        this.scheduleUIUpdate();
    }

    private void asyncExec(final Runnable runnable) {
        final Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay == null || !currentDisplay.equals(control.getDisplay())) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        public UpdateUIJob() {
            super("Update Search Results View");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = GitGrepSearchResultPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return Status.OK_STATUS;
            }
            this.runBatchedClear();
            this.runBatchedUpdates();
            if (this.hasMoreUpdates() || this.isQueryRunning()) {
                this.schedule(1L);
            } else {
                GitGrepSearchResultPage.this.fIsUIUpdateScheduled = false;
                GitGrepSearchResultPage.this.updateBusyLabel();
                if (GitGrepSearchResultPage.this.fScheduleEnsureSelection) {
                    GitGrepSearchResultPage.this.fScheduleEnsureSelection = false;
                }
            }
            GitGrepSearchResultPage.this.fViewPart.updateLabel();
            return Status.OK_STATUS;
        }

        private boolean hasMoreUpdates() {
            return GitGrepSearchResultPage.this.fBatchedClearAll || GitGrepSearchResultPage.this.fBatchedUpdates.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runBatchedClear() {
            UpdateUIJob updateUIJob = this;
            synchronized (updateUIJob) {
                if (!GitGrepSearchResultPage.this.fBatchedClearAll) {
                    return;
                }
                GitGrepSearchResultPage.this.fBatchedClearAll = false;
                GitGrepSearchResultPage.this.updateBusyLabel();
            }
            GitGrepSearchResultPage.this.fViewPart.updateLabel();
            GitGrepSearchResultPage.this.fViewer.refresh();
        }

        private synchronized void runBatchedUpdates() {
            GitGrepSearchResultPage.this.fViewer.refresh();
            GitGrepSearchResultPage.this.fBatchedUpdates.clear();
            GitGrepSearchResultPage.this.updateBusyLabel();
        }

        private boolean isQueryRunning() {
            GitGrepSearchResult result = GitGrepSearchResultPage.this.fInput;
            if (result != null) {
                return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
            }
            return false;
        }

        public boolean belongsTo(Object family) {
            return family == GitGrepSearchResultPage.this;
        }
    }
}

