/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.proalpha.pds.pagit.model.server.BitbucketRepository;
import com.proalpha.pds.pagit.model.server.BitbucketRestRepoListResponse;
import com.proalpha.pds.pagit.model.server.GitServerRepository;
import com.proalpha.pds.pagit.util.bitbucket.BitbucketRestCall;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketRestCallGetRepoList
extends BitbucketRestCall<ArrayList<GitServerRepository>> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketRestCallGetRepoList.class);

    @Override
    protected ArrayList<GitServerRepository> parseRestResponse(InputStream response) throws IOException {
        ArrayList<GitServerRepository> repoList = new ArrayList<GitServerRepository>();
        try {
            BitbucketRestRepoListResponse resp = (BitbucketRestRepoListResponse)new ObjectMapper().readValue(response, BitbucketRestRepoListResponse.class);
            for (BitbucketRepository repo : resp.getValues()) {
                GitServerRepository gitRepo = new GitServerRepository();
                gitRepo.setServerType(GitServerRepository.ServerType.BITBUCKET);
                gitRepo.setName(repo.getName());
                gitRepo.setProject(repo.getProject().getKey());
                this.logger.debug("Add Repository: {}", (Object)gitRepo.getName());
                repoList.add(gitRepo);
            }
            if (!resp.getIsLastPage().booleanValue()) {
                this.setStartEntry(resp.getNextPageStart());
                this.execute();
                repoList.addAll((Collection)this.getRestResponse());
            }
        }
        catch (NullPointerException e) {
            this.logger.debug("NPE occured, due to empty http-response {}", (Object)e.getMessage());
        }
        return repoList;
    }
}

