/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.utils;

import com.proalpha.pds.projconf.utils.DemasFile;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Project
implements Comparable<Project> {
    private static final String PA_PROJECT_CREATED_TAG = "project-created";
    private Path rootPath;
    private DemasFile demasFile;
    private boolean imported;
    private boolean open;

    public Project(Path rootPath) {
        this.rootPath = rootPath;
        this.demasFile = new DemasFile(this.demasConfigFilePath().toString());
        this.imported = false;
        this.open = false;
    }

    public Project(Path rootPath, String name, boolean imported, boolean open) {
        this.rootPath = rootPath;
        this.demasFile = new DemasFile(rootPath.resolve("PDSconfig.properties").toString());
        this.imported = imported;
        this.open = open;
    }

    public Path demasConfigFilePath() {
        return this.rootPath.resolve("PDSconfig.properties");
    }

    public Path dbConfigFilePath() {
        return this.rootPath.resolve("dbconnection.properties");
    }

    public DemasFile demasFile() {
        return this.demasFile;
    }

    public String name() {
        return this.demasFile.getFullProjectName();
    }

    public boolean imported() {
        return this.imported;
    }

    public boolean open() {
        return this.open;
    }

    public int dbPort() {
        try {
            Properties dbConnectionProperties = new Properties();
            dbConnectionProperties.load(new FileReader(this.dbConfigFilePath().toFile()));
            return Integer.parseInt(dbConnectionProperties.getProperty("basis.dbPort"));
        }
        catch (IOException e) {
            return 0;
        }
    }

    public String progressVersion() {
        try {
            Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+");
            Matcher matcher = pattern.matcher(new String(Files.readAllBytes(Paths.get(this.demasFile.getDlc(), new String[0]).resolve("version"))));
            if (matcher.find()) {
                return matcher.group();
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public boolean fullyCreated() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.rootPath.resolve(".git").toFile())).readEnvironment()).findGitDir()).build());){
                return git.tagList().call().stream().map(tag -> tag.getName().substring(10)).anyMatch(PA_PROJECT_CREATED_TAG::equals);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String type() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileReader reader = new FileReader(this.rootPath.resolve("pa_config_project.json").toFile());){
                JSONObject obj = (JSONObject)new JSONParser().parse((Reader)reader);
                if (obj.containsKey((Object)"repository_type")) {
                    return (String)obj.get((Object)"repository_type");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int compareTo(Project other) {
        return this.name().compareTo(other.name());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return this.name().equals(other.name());
    }

    private static List<Project> installedProjects(Path pathToProjects) {
        return Arrays.stream(pathToProjects.toFile().listFiles(File::isDirectory)).flatMap(dir -> {
            List subDirectories = Arrays.stream(dir.listFiles(File::isDirectory)).collect(Collectors.toList());
            subDirectories.add(dir);
            return subDirectories.stream();
        }).map(dir -> {
            if (!Files.exists(dir.toPath().resolve("dev").resolve("PDSconfig.properties"), new LinkOption[0])) {
                return null;
            }
            return new Project(dir.toPath().resolve("dev"));
        }).filter(project -> project != null).collect(Collectors.toList());
    }

    private static List<Project> importedProjects() {
        return Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().getProjects()).map(p -> new Project(p.getLocation().toFile().toPath(), p.getName(), true, p.isOpen())).collect(Collectors.toList());
    }

    public static List<Project> all(Path pathToProjects) {
        List<Project> installed = Project.installedProjects(pathToProjects);
        List<Project> imported = Project.importedProjects();
        for (Project in : installed) {
            if (Project.findProjectByName(in.name(), imported) != null) continue;
            imported.add(in);
        }
        return imported;
    }

    public static Project findProjectByName(String name, List<Project> projects) {
        for (Project project : projects) {
            if (!project.name().equals(name)) continue;
            return project;
        }
        return null;
    }

    public static Project findProjectByDeMasConfigFile(Path path, List<Project> projects) {
        for (Project project : projects) {
            if (!project.demasConfigFilePath().equals(path)) continue;
            return project;
        }
        return null;
    }
}

