/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.openedge.pdt.core.template.TemplateGenerationException;
import com.proalpha.pds.generator.ContentWriter;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.templates.helper.IDEUtils;
import com.proalpha.pds.templates.jet.IpaTemplateGenerator;
import com.proalpha.pds.templates.jet.JetTemplateFactory;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ContentGenerator
extends UIJob {
    public static final String JOB_FAMILY = "com.proalpha.java.oea.plugins.generator.AbstractGenerator";
    private final IpaTemplateGenerator templateGenerator;
    private final IGeneratorDataContainer dataContainer;
    private Boolean isOpenFileInEditor = Boolean.TRUE;

    public ContentGenerator(String name, IGeneratorDataContainer dataContainer, String templateGeneratorName) throws Exception {
        this(name, dataContainer, JetTemplateFactory.getFactoryInstance(dataContainer.getVersion()).getTemplate(templateGeneratorName));
    }

    public ContentGenerator(String name, IGeneratorDataContainer dataContainer, IpaTemplateGenerator templateGenerator) throws Exception {
        super(name);
        this.dataContainer = dataContainer;
        this.templateGenerator = templateGenerator;
        this.setUser(true);
        this.setPriority(20);
    }

    private void generate(IProgressMonitor monitor) throws Exception {
        IFile outputFile = this.dataContainer.getOutputFile();
        if (this.templateGenerator == null) {
            throw new TemplateGenerationException("Template generator is not set.");
        }
        String outputContent = this.templateGenerator.generate(this.dataContainer.getDataAsMap());
        File file = outputFile.getLocation().toFile();
        ContentWriter contentWriter = new ContentWriter(file, outputContent);
        contentWriter.writeContentToHarddisk();
        if (this.isOpenFileInEditor.booleanValue()) {
            IDEUtils.openFileInEditor(monitor, outputFile);
        }
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        monitor.beginTask("User Exit Include File", 2);
        monitor.worked(1);
        try {
            if (!this.dataContainer.isGenerationConfirmed().booleanValue()) {
                return Status.CANCEL_STATUS;
            }
            this.generate(monitor);
            monitor.done();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"NO USER EXITS", (String)e.getMessage());
            return Status.CANCEL_STATUS;
        }
    }

    public boolean belongsTo(Object family) {
        if (family instanceof String) {
            return ((String)family).equals(JOB_FAMILY);
        }
        return false;
    }

    public void disableOpenFileInEditor() {
        this.isOpenFileInEditor = Boolean.FALSE;
    }

    public void enableOpenFileInEditro() {
        this.isOpenFileInEditor = Boolean.TRUE;
    }
}

