/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.helper;

public final class ReturnTypeAnayzer {
    private ReturnTypeAnayzer() {
    }

    public static String getPrefixForDataType(String dataType) {
        DataTypeEnum dataTypeEnum = null;
        try {
            dataTypeEnum = DataTypeEnum.valueOf(dataType.toUpperCase().replace("-", "_"));
        }
        catch (IllegalArgumentException e) {
            dataTypeEnum = DataTypeEnum.OOABL;
        }
        return dataTypeEnum.getPrefix();
    }

    private static enum DataTypeEnum {
        BLOB("blob", "bl"),
        CHARACTER("character", "c"),
        CLOB("clob", "cl"),
        COM_HANDLE("com-handle", "ch"),
        DECIMAL("decimal", "d"),
        HANDLE("handle", "h"),
        INTEGER("integer", "i"),
        IMAGE("image", "s"),
        LOGICAL("logical", "l"),
        LONG_CHAR("long-char", "cl"),
        MEMPTR("memptr", "m"),
        OOABL("ooabl", "o"),
        ROWID("rowid", "r"),
        DATE("date", "t"),
        DATETIME("datetime", "td"),
        DATETIME_TZ("datetime-tz", "tz");

        private String dataType;
        private String prefix;

        private DataTypeEnum(String dataType, String prefix) {
            this.dataType = dataType;
            this.prefix = prefix;
        }

        public String toString() {
            return this.dataType;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

