/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.wizards.controller.PaWizard;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOABLObject
extends PaWizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(OOABLObject.class);
    private static final String OO_ROOT_CLASS = "OOABL";
    private static final String CUSTOM_CLASS_SUFFIX_PATTERN = "Std.cls|[C,X,Y].cls|.cls";
    private String currentCustomLevel = null;
    private Boolean isGenerateUserExit;

    public OOABLObject() {
        try {
            this.isGenerateUserExit = Boolean.FALSE;
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("cls");
            WizardMainPageConfiguration configuration = new WizardMainPageConfiguration();
            configuration.setWizardTitle("Proalpha OOABL Class File");
            configuration.setWizardDescription("This wizard creates a new Proalpha OOABL Class File.");
            configuration.setTemplateName("pAOOABLClass");
            configuration.setExtensionList(extensionList);
            configuration.setRootClass(OO_ROOT_CLASS);
            configuration.setThirdDigit("C");
            configuration.setCheckRepository(true);
            configuration.setSupportRepositoryCreateButton(true);
            configuration.setCheckFileNameLength(false);
            configuration.setCheckLowerCase(false);
            WizardMainPageConfiguration configuration1 = new WizardMainPageConfiguration();
            configuration1.setWizardTitle("Proalpha OOABL Form File");
            configuration1.setWizardDescription("This wizard creates a new Proalpha OOABL Form File.");
            configuration1.setTemplateName("pAOOABLForm");
            configuration1.setExtensionList(extensionList);
            configuration1.setRootClass(OO_ROOT_CLASS);
            configuration1.setThirdDigit("C");
            configuration1.setCheckRepository(true);
            configuration1.setSupportRepositoryCreateButton(true);
            configuration1.setCheckFileNameLength(false);
            configuration1.setCheckLowerCase(false);
            WizardMainPageConfiguration configuration2 = new WizardMainPageConfiguration();
            configuration2.setWizardTitle("Proalpha Interface File");
            configuration2.setWizardDescription("This wizard creates a new Proalpha Interface File.");
            configuration2.setTemplateName("pAOOABLInterface");
            configuration2.setExtensionList(extensionList);
            configuration2.setRootClass(OO_ROOT_CLASS);
            configuration2.setThirdDigit("I");
            configuration2.setCheckRepository(true);
            configuration2.setSupportRepositoryCreateButton(true);
            configuration2.setCheckFileNameLength(false);
            configuration2.setCheckLowerCase(false);
            LinkedHashMap<String, WizardMainPageConfiguration> configList = new LinkedHashMap<String, WizardMainPageConfiguration>();
            configList.put("OOABL Class", configuration);
            configList.put("OOABL Form", configuration1);
            configList.put("OOABL Interface", configuration2);
            this.setConfigList(configList);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    private Map<String, Object> cloneWizardSettings() {
        HashMap<String, Object> exitFileGeneratorSettings = new HashMap<String, Object>();
        for (Map.Entry entry : this.wizardSettings.entrySet()) {
            exitFileGeneratorSettings.put((String)entry.getKey(), entry.getValue());
        }
        return exitFileGeneratorSettings;
    }

    @Override
    protected boolean doFinish() {
        try {
            if (this.isGenerateUserExit.booleanValue()) {
                this.generateUserExitClassAndBalpEntry();
            } else {
                this.generatorMainClassAndStdClass();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void generatorMainClassAndStdClass() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        fileName = this.getCurrentCustomLevel().equals("") && !fileName.endsWith("Std.cls") ? fileName.replace(".", "Std.") : fileName.replaceAll(CUSTOM_CLASS_SUFFIX_PATTERN, String.valueOf(this.getCurrentCustomLevel()) + ".");
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel());
        this.wizardSettings.put("CustomFileName", fileName);
        this.wizardSettings.put("StandardFileName", fileName);
        DataContainerFactory factory = new DataContainerFactory();
        IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.cloneWizardSettings());
        GeneratorFactory generatorFactory = new GeneratorFactory();
        String stdTemplate = this.wizardSettings.get("TemplateName").toString();
        if (!stdTemplate.endsWith("Form")) {
            stdTemplate = stdTemplate.replace("pAOOABL", "pAOOABLStd");
        }
        OOABLExitFileGenerator oOABLClass = generatorFactory.createOOABLExitFileGenerator(datacontainer, stdTemplate);
        if (this.getCurrentCustomLevel().equals("")) {
            oOABLClass.generate();
        } else {
            oOABLClass.generateUserExitClassAndBalpEntry();
        }
        super.doFinish();
    }

    private void generateUserExitClassAndBalpEntry() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel());
        this.wizardSettings.put("CustomFileName", fileName);
        DataContainerFactory factory = new DataContainerFactory();
        IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.wizardSettings);
        OOABLExitFileGenerator oOABLClass = null;
        GeneratorFactory generatorFactory = new GeneratorFactory();
        oOABLClass = this.wizardSettings.get("TemplateName").toString().equals("pAOOABLInterface") ? generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdInterface") : generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdClass");
        oOABLClass.generateUserExitClassAndBalpEntry();
    }

    public void setCurrentCustomLevel(String currentCustomLevel) {
        this.currentCustomLevel = currentCustomLevel;
    }

    public String getCurrentCustomLevel() {
        if (this.currentCustomLevel == null) {
            this.currentCustomLevel = this.getStartparameterReader().getCurrentCustomLevel();
        }
        return this.currentCustomLevel;
    }

    public void setIsGerateUserExit(Boolean value) {
        this.isGenerateUserExit = value;
    }
}

