/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.model;

import com.progress.tools.reportbug.model.Attachment;
import com.progress.tools.reportbug.zipper.SizeCalculator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileAttachment
extends Attachment {
    protected String fileLocation;
    private InputStream is;

    public FileAttachment(String pathInZip, String fileLocation) {
        super(pathInZip);
        this.fileLocation = fileLocation;
    }

    public FileAttachment() {
    }

    protected void init(String pathInZip, String fileLocation) {
        this.setPathInZip(pathInZip);
        this.fileLocation = fileLocation;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    @Override
    public long getLength() {
        File f = new File(this.fileLocation);
        return SizeCalculator.calculateSize(f);
    }

    public boolean equals(Object obj) {
        FileAttachment pathAttachment;
        return obj instanceof FileAttachment && (pathAttachment = (FileAttachment)obj).getFileLocation().equals(this.fileLocation);
    }

    public boolean isDirectory() {
        return new File(this.getFileLocation()).isDirectory();
    }

    @Override
    public void openStream() {
        File file = new File(this.fileLocation);
        try {
            this.is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int readChunk(byte[] bytes) {
        int i = -1;
        try {
            i = this.is.read(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return i;
    }

    @Override
    public void closeStream() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

