/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core;

import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.Messages;
import com.atlassian.connector.eclipse.internal.jira.core.model.Attachment;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.UnsubmittedTaskAttachment;

public class JiraTaskAttachmentHandler
extends AbstractTaskAttachmentHandler {
    public boolean canGetContent(TaskRepository repository, ITask task) {
        return true;
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return true;
    }

    private InputStream downloadAttachment(TaskRepository repository, ITask task, String attachmentId, IProgressMonitor monitor) throws CoreException {
        JiraClient client = JiraClientFactory.getDefault().getJiraClient(repository);
        try {
            JiraIssue issue = client.getIssueByKey(task.getTaskKey(), monitor);
            Attachment jiraAttachment = issue.getAttachmentById(attachmentId);
            if (jiraAttachment == null) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", "Attachment with id \"" + attachmentId + "\" for JIRA issue \"" + task.getTaskKey() + "\" not found"));
            }
            return client.getAttachment(issue, jiraAttachment, monitor);
        }
        catch (JiraException e) {
            throw new CoreException(JiraCorePlugin.toStatus(repository, e));
        }
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask(Messages.JiraTaskAttachmentHandler_Getting_attachment, -1);
            TaskAttachmentMapper attachment = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
            InputStream inputStream = this.downloadAttachment(repository, task, attachment.getAttachmentId(), monitor);
            return inputStream;
        }
        finally {
            monitor.done();
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            TaskAttachmentMapper mapper;
            UnsubmittedTaskAttachment taskAttachment = new UnsubmittedTaskAttachment(source, attachmentAttribute);
            monitor.beginTask(Messages.JiraTaskAttachmentHandler_Sending_attachment, -1);
            String filename = source.getName();
            if (attachmentAttribute != null && (mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute)).getFileName() != null) {
                filename = mapper.getFileName();
            }
            InputStream is = source.createInputStream(monitor);
            JiraClient server = JiraClientFactory.getDefault().getJiraClient(repository);
            try {
                try {
                    JiraIssue issue = server.getIssueByKey(task.getTaskKey(), monitor);
                    server.addAttachment(issue, comment, filename, IOUtils.toByteArray((InputStream)is), monitor);
                }
                catch (JiraException e) {
                    throw new CoreException(JiraCorePlugin.toStatus(repository, e));
                }
                catch (IOException e) {
                    throw new CoreException(JiraCorePlugin.toStatus(repository, e));
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        finally {
            monitor.done();
        }
    }
}

