/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.JaxbUtil;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.ObjectFactory;
import rabbit.tracking.internal.TrackingPlugin;

public enum DataStore implements IDataStore
{
    COMMAND_STORE("commandEvents"),
    PART_STORE("partEvents"),
    PERSPECTIVE_STORE("perspectiveEvents"),
    FILE_STORE("fileEvents"),
    TASK_STORE("taskEvents"),
    LAUNCH_STORE("launchEvents"),
    SESSION_STORE("sessionEvents"),
    JAVA_STORE("javaEvents");

    private final ObjectFactory objectFactory = new ObjectFactory();
    private String id;

    private DataStore(String id) {
        this.id = id;
    }

    @Override
    public File getDataFile(IPath location) {
        if (location == null) {
            location = this.getStorageLocation();
        }
        return location.append(this.id).addFileExtension("xml").toFile();
    }

    @Override
    public List<File> getDataFiles(IPath location) {
        location = TrackingPlugin.getDefault().getStoragePath();
        LinkedList result = Lists.newLinkedList();
        File f = this.getDataFile(location);
        if (f.exists()) {
            result.add(f);
        }
        return result;
    }

    @Override
    public IPath getStorageLocation() {
        IPath path = TrackingPlugin.getDefault().getStoragePath();
        File f = path.toFile();
        if (!f.exists() && !f.mkdirs()) {
            TrackingPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.openedge.pdt.analytics", "Unable to create storage location. Perhaps no write permission?\n" + f.getAbsolutePath()));
        }
        return path;
    }

    @Override
    public EventListType read(File file) {
        try {
            JAXBElement element;
            Object obj;
            if (file.exists() && (obj = JaxbUtil.unmarshal(file)) instanceof JAXBElement && (element = (JAXBElement)obj).getValue() instanceof EventListType) {
                return (EventListType)element.getValue();
            }
        }
        catch (JAXBException jAXBException) {
            return this.objectFactory.createEventListType();
        }
        catch (Exception e) {
            TrackingPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.openedge.pdt.analytics", e.getMessage(), (Throwable)e));
            return this.objectFactory.createEventListType();
        }
        return this.objectFactory.createEventListType();
    }

    @Override
    public boolean write(EventListType doc, File f) {
        if (doc == null || f == null) {
            throw new NullPointerException();
        }
        try {
            JaxbUtil.marshal(this.objectFactory.createEvents(doc), f);
            return true;
        }
        catch (JAXBException e) {
            TrackingPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.openedge.pdt.analytics", "Unable to save data.", (Throwable)e));
            return false;
        }
    }
}

