/*
 * Decompiled with CFR 0.152.
 */
package rabbit.tracking.internal.trackers;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import rabbit.data.store.IStorer;
import rabbit.tracking.ITracker;

public abstract class AbstractTracker<T>
implements ITracker<T> {
    private boolean isEnabled = false;
    private Set<T> data = new LinkedHashSet<T>();
    private IStorer<T> storer = this.createDataStorer();

    public AbstractTracker() {
        Assert.isNotNull(this.storer);
    }

    public void addData(T o) {
        this.data.add(o);
    }

    @Override
    public void flushData() {
        this.data.clear();
    }

    @Override
    public Collection<T> getData() {
        return Collections.unmodifiableSet(this.data);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void saveData() {
        if (!this.getData().isEmpty()) {
            this.storer.insert(this.getData());
            this.storer.commit();
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.isEnabled() != enable) {
            if (enable) {
                this.flushData();
                this.doEnable();
            } else {
                this.doDisable();
                this.saveData();
            }
            this.isEnabled = enable;
        }
    }

    protected abstract IStorer<T> createDataStorer();

    protected abstract void doDisable();

    protected abstract void doEnable();
}

