/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.common;

import java.util.Date;

public final class TaskId {
    private final String handleId;
    private final Date creationDate;

    public TaskId(String handleId, Date creationDate) {
        if (handleId == null || creationDate == null) {
            throw new NullPointerException();
        }
        if (handleId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.handleId = handleId;
        this.creationDate = (Date)creationDate.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskId) {
            TaskId id = (TaskId)obj;
            return this.handleId.equals(id.getHandleIdentifier()) && this.creationDate.equals(id.getCreationDate());
        }
        return false;
    }

    public Date getCreationDate() {
        return (Date)this.creationDate.clone();
    }

    public String getHandleIdentifier() {
        return this.handleId;
    }

    public int hashCode() {
        return this.handleId.hashCode();
    }

    public String toString() {
        return "Handle ID: " + this.handleId + ", creation date: " + this.creationDate.toString();
    }
}

