/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.access.model;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPartDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IKey;
import rabbit.data.access.model.IPartData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.KeyMapBuilder;

public class PartData
implements IPartData {
    private final Map<IKey<? extends Object>, Object> data;

    public PartData(LocalDate date, WorkspaceStorage workspace, Duration duration, String partId) {
        this.data = new KeyMapBuilder().put(DATE, (LocalDate)Preconditions.checkNotNull((Object)date, (Object)"date")).put(WORKSPACE, (WorkspaceStorage)Preconditions.checkNotNull((Object)workspace, (Object)"workspace")).put(DURATION, (Duration)Preconditions.checkNotNull((Object)duration, (Object)"duration")).put(PART_ID, (String)Preconditions.checkNotNull((Object)partId, (Object)"partId")).build();
    }

    @Override
    public <T> T get(@Nullable IKey<T> key) {
        return (T)this.data.get(key);
    }

    @Override
    public IWorkbenchPartDescriptor getPart() {
        IViewDescriptor part = this.viewRegistry().find((String)this.get(PART_ID));
        if (part == null) {
            return this.editorRegistry().findEditor((String)this.get(PART_ID));
        }
        return part;
    }

    private IEditorRegistry editorRegistry() {
        return PlatformUI.getWorkbench().getEditorRegistry();
    }

    private IViewRegistry viewRegistry() {
        return PlatformUI.getWorkbench().getViewRegistry();
    }
}

