/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.access.model;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IKey;
import rabbit.data.access.model.IPerspectiveData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.KeyMapBuilder;

public class PerspectiveData
implements IPerspectiveData {
    private final Map<IKey<? extends Object>, Object> data;

    public PerspectiveData(LocalDate date, WorkspaceStorage workspace, Duration duration, String perspectiveId) {
        this.data = new KeyMapBuilder().put(DATE, (LocalDate)Preconditions.checkNotNull((Object)date, (Object)"date")).put(WORKSPACE, (WorkspaceStorage)Preconditions.checkNotNull((Object)workspace, (Object)"workspace")).put(DURATION, (Duration)Preconditions.checkNotNull((Object)duration, (Object)"duration")).put(PERSPECTIVE_ID, (String)Preconditions.checkNotNull((Object)perspectiveId, (Object)"perspectiveId")).build();
    }

    @Override
    public <T> T get(@Nullable IKey<T> key) {
        return (T)this.data.get(key);
    }

    @Override
    public IPerspectiveDescriptor getPerspective() {
        return PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId((String)this.get(PERSPECTIVE_ID));
    }
}

