/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import org.eclipse.core.commands.Command;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.joda.time.LocalDate;
import rabbit.data.access.model.ICommandData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.CommandData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.CommandEventListType;
import rabbit.data.internal.xml.schema.events.CommandEventType;
import rabbit.data.internal.xml.schema.events.EventListType;

public class CommandDataAccessor
extends AbstractAccessor<ICommandData, CommandEventType, CommandEventListType> {
    @Inject
    CommandDataAccessor(@Named(value="CommandStore") IDataStore store) {
        super(store);
    }

    @Override
    protected ICommandData createDataNode(LocalDate date, WorkspaceStorage ws, CommandEventType type) throws Exception {
        Command cmd = this.commandService().getCommand(type.getCommandId());
        return new CommandData(date, ws, cmd, type.getCount());
    }

    @Override
    protected Collection<CommandEventListType> getCategories(EventListType doc) {
        return doc.getCommandEvents();
    }

    @Override
    protected Collection<CommandEventType> getElements(CommandEventListType list) {
        return list.getCommandEvent();
    }

    private ICommandService commandService() {
        return (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    }
}

