/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.access.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;

public class LaunchConfigurationDescriptor {
    private final String launchName;
    private final String launchModeId;
    private final String launchTypeId;

    public LaunchConfigurationDescriptor(String name, String launchModeId, String launchTypeId) {
        this.launchName = (String)Preconditions.checkNotNull((Object)name);
        this.launchModeId = (String)Preconditions.checkNotNull((Object)launchModeId);
        this.launchTypeId = (String)Preconditions.checkNotNull((Object)launchTypeId);
    }

    public final ILaunchConfigurationType findLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getLaunchTypeId());
    }

    public final ILaunchMode findLaunchMode() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getLaunchModeId());
    }

    public final String getLaunchModeId() {
        return this.launchModeId;
    }

    public final String getLaunchTypeId() {
        return this.launchTypeId;
    }

    public final String getLaunchName() {
        return this.launchName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getLaunchName(), this.getLaunchModeId(), this.getLaunchTypeId()});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchConfigurationDescriptor des = (LaunchConfigurationDescriptor)obj;
        return this.getLaunchName().equals(des.getLaunchName()) && this.getLaunchModeId().equals(des.getLaunchModeId()) && this.getLaunchTypeId().equals(des.getLaunchTypeId());
    }
}

