/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.runtime.IPath;
import org.joda.time.LocalDate;
import rabbit.data.access.IAccessor;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.xml.DatatypeUtil;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.schema.events.EventGroupType;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.tracking.internal.TrackingPlugin;

public abstract class AbstractAccessor<T, E, S extends EventGroupType>
implements IAccessor<T> {
    private final IDataStore store;

    protected AbstractAccessor(IDataStore store) {
        this.store = (IDataStore)Preconditions.checkNotNull((Object)store);
    }

    @Override
    public final Collection<T> getData(LocalDate start, LocalDate end) {
        return this.filter(this.getXmlData((LocalDate)Preconditions.checkNotNull((Object)start, (Object)"start date is null"), (LocalDate)Preconditions.checkNotNull((Object)end, (Object)"end date is null")));
    }

    protected abstract T createDataNode(LocalDate var1, WorkspaceStorage var2, E var3) throws Exception;

    protected abstract Collection<S> getCategories(EventListType var1);

    protected final IDataStore getDataStore() {
        return this.store;
    }

    protected abstract Collection<E> getElements(S var1);

    private Collection<T> filter(Multimap<WorkspaceStorage, S> data) {
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : data.entries()) {
            LocalDate date = DatatypeUtil.toLocalDate(((EventGroupType)entry.getValue()).getDate());
            for (E element : this.getElements((EventGroupType)entry.getValue())) {
                Object node = null;
                try {
                    node = this.createDataNode(date, (WorkspaceStorage)entry.getKey(), element);
                }
                catch (Exception exception) {
                    node = null;
                }
                if (node == null) continue;
                result.add(node);
            }
        }
        return result;
    }

    private Multimap<WorkspaceStorage, S> getXmlData(LocalDate start, LocalDate end) {
        XMLGregorianCalendar startDate = DatatypeUtil.toXmlDate(start);
        XMLGregorianCalendar endDate = DatatypeUtil.toXmlDate(end);
        TrackingPlugin plugin = TrackingPlugin.getDefault();
        IPath path = plugin.getStoragePath();
        LinkedListMultimap data = LinkedListMultimap.create((int)1);
        LinkedListMultimap files = LinkedListMultimap.create((int)1);
        List<File> fileList = this.getDataStore().getDataFiles(path);
        IPath workspacePath = plugin.getWorkspacePath(path);
        files.putAll((Object)new WorkspaceStorage(path, workspacePath), fileList);
        for (Map.Entry entry : files.entries()) {
            for (EventGroupType list : this.getCategories(this.getDataStore().read((File)entry.getValue()))) {
                XMLGregorianCalendar date = list.getDate();
                if (date == null || startDate.compare(date) > 0 || date.compare(endDate) > 0) continue;
                data.put((Object)((WorkspaceStorage)entry.getKey()), (Object)list);
            }
        }
        return data;
    }
}

