/*
 * Decompiled with CFR 0.152.
 */
package rabbit.data.internal.xml.access;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import rabbit.data.access.model.IPartData;
import rabbit.data.access.model.WorkspaceStorage;
import rabbit.data.internal.access.model.PartData;
import rabbit.data.internal.xml.IDataStore;
import rabbit.data.internal.xml.access.AbstractAccessor;
import rabbit.data.internal.xml.schema.events.EventListType;
import rabbit.data.internal.xml.schema.events.PartEventListType;
import rabbit.data.internal.xml.schema.events.PartEventType;

public class PartDataAccessor
extends AbstractAccessor<IPartData, PartEventType, PartEventListType> {
    @Inject
    PartDataAccessor(@Named(value="PartStore") IDataStore store) {
        super(store);
    }

    @Override
    protected Collection<PartEventListType> getCategories(EventListType doc) {
        return doc.getPartEvents();
    }

    @Override
    protected IPartData createDataNode(LocalDate date, WorkspaceStorage ws, PartEventType t) throws Exception {
        return new PartData(date, ws, new Duration(t.getDuration()), t.getPartId());
    }

    @Override
    protected Collection<PartEventType> getElements(PartEventListType list) {
        return list.getPartEvent();
    }
}

